Program LameFrontend;

USES WinDos,WinFelix,WinProcs,ODialogs,Strings,OWindows,WinTypes,CommDlg,FJOFAT32;

CONST AppName = 'WinLame';
      ExeName = AppName;

      rates : array[0..3]of chararr = ('samplerates(kHz): 32 44.1 48',
                                       'bitrates(kbs): 32 48 56 64 80 96 112 128 160 192 224 256 320',
                                       'samplerates(kHz): 16 22.05 24',
                                       'bitrates(kbs): 8 16 24 32 40 48 56 64 80 96 112 128 144 160');

      id_Open = 1001;
      id_Batch = 1003;
      id_Start = 1004;
      id_Lame = 1005;
      id_Timer = 1006;
      id_BitScroll = 1002;
      id_VBRScroll = 1007;

TYPE PFJOWin = ^TFJOWin;
     TFJOWin = object(TWindow2)
                 GroupBox : PGroupBox;
                 Button : PButton;
                 Edit : Array[1..5]of PEdit;
                 RadioButton : Array[0..3]of PRadioButton;
                 CheckBox : Array[0..11]of PCheckBox;
                 PS,PS2 : PStatic;
                 PBar : PScrollBar;
                 thecommand : CharArr;
                 OpenFN : TOpenFileName;
                 Filter,FileName,FullFileName : CharArr;
                 procedure CalculateCommand;
                 procedure SetupWindow;virtual;
                 procedure OpenInput (var msg : TMessage); virtual id_First + id_Open;
                 procedure Batch (var msg : TMessage); virtual id_First + id_Batch;
                 procedure Start (var msg : TMessage); virtual id_First + id_Start;
                 procedure Lame (var msg : TMessage); virtual id_First + id_Lame;
                 constructor Init ( AParent : PWindowsObject; ATitle : PChar );
                 destructor Done;virtual;
                 procedure DoTimer (var msg : TMessage);virtual wm_First + wm_Timer;
               end;

var sr : long_SearchRec;
    temp2,renamedat,command,temp,Filter2 : CharArr;

const StartConversion : Boolean = False;
      ScrollPos : Integer = 0;
      ScrollSwap : ShortInt = 1;
      Lamenotfound : Byte = 1;

procedure TFJOWin.DoTimer;
begin
 AllowScreenSaver:=CheckBox[10]^.GetCheck=bf_Checked;
 PS2^.SetText(i2pc(PBar^.GetPosition));
 Edit[1]^.Scroll(ScrollSwap,0);
 Inc(ScrollPos,ScrollSwap);
 Edit[1]^.GetText(temp2,512);
 If(ScrollPos>=integer(StrLen(temp2))-30)or(ScrollPos<=0)then ScrollSwap:=-ScrollSwap;
 If StartConversion then
   If FindWindow(NIL,'LAME')=0then
   begin
     inc(Lamenotfound);
     If Lamenotfound>8then
     begin
       If not long_err then
       begin
         If StrComp(renamedat,'')<>0then
         begin
           StrCopy(temp,renamedat);
           StrCat(temp,'.mp3');
           StrLCopy(temp2,temp,StrLen(temp)-7);
           StrCat(temp2,'mp3');
           long_Rename(temp,temp2);
           If(not long_err)and(Checkbox[10]^.GetCheck=bf_Checked)then
           begin
              long_Erase(renamedat);
              StrCat(renamedat,' can not be erased');
              If long_err then MessageBox(HWindow,renamedat,AppName,mb_IconExclamation);
           end;
         end;
         StrCopy(command,thecommand);
         StrCat(command,' "');
         StrCat(command,Filter2);
         StrCat(command,sr.fullname);
         StrCat(command,'"');
         i:=PBar^.GetPosition;
         Case i of
           0: WinExec(command,sw_Hide);
           1: WinExec(command,sw_Minimize);
           2: WinExec(command,sw_ShowNoActivate);
           3: WinExec(command,sw_ShowMinimized);
           4: WinExec(command,sw_Restore);
          end;
         StrCopy(temp,'priority level ');
         StrCat(temp,i2pc(i));
         StrCat(temp,': ');
         StrCat(temp,command);
{         PS^.SetText(temp);}
         StartConversion:=True;
         Lamenotfound:=0;
         StrCopy(renamedat,sr.fullname);
         long_FindNext(sr);
       end
        else
       begin
         StartConversion:=false;
         If StrComp(renamedat,'')<>0then
         begin
           StrCopy(temp,renamedat);
           StrCat(temp,'.mp3');
           StrLCopy(temp2,temp,StrLen(temp)-7);
           StrCat(temp2,'mp3');
           long_Rename(temp,temp2);
           If(not long_err)and(Checkbox[10]^.GetCheck=bf_Checked)then
           begin
              long_Erase(renamedat);
              StrCat(renamedat,' can not be erased');
              If long_err then MessageBox(HWindow,renamedat,AppName,mb_IconExclamation);
           end;
         end;
{         PS^.SetText('ready');}
       end;
     end;
   end;
end;

procedure TFJOWin.Start;
begin
 If FindWindow(NIL,'LAME')<>0then
 begin
   MessageBox(HWindow,'LAME already running',AppName,mb_Ok or mb_IconExclamation);
   Exit;
 end;
 Edit[5]^.GetText(Filter,512);
 If StrComp(Filter,'')=0then
 begin
   If MessageBox(HWindow,'first you have to specify a path to LAME.EXE',AppName,mb_OkCancel or mb_IconStop)=id_Ok
      then Lame(msg)else Exit;
   Edit[5]^.GetText(Filter,512);
   If StrComp(Filter,'')=0then Exit;
 end;
 Edit[3]^.GetText(Filter,512);
 If(StrComp(Filter,'')=0)and(CheckBox[4]^.GetCheck=bf_UnChecked)then
 begin
   MessageBox(HWindow,'You disabled VBR. So enter a valid bitrate.',AppName,mb_Ok or mb_IconExclamation);
   Exit;
 end;
 Edit[1]^.GetText(Filter,512);
 If StrComp(Filter,'')=0then
 begin
   OpenInput(msg);
   Edit[1]^.GetText(Filter,512);
   If StrComp(Filter,'')=0then
   begin
     MessageBox(HWindow,'sorry, but you have to specify a valid input pcm file before starting any conversion',AppName,
                mb_Ok or mb_IconExclamation);
     Exit;
   end;
 end;
 CalculateCommand;
 Edit[1]^.GetText(Filter2,512);
 long_FindFirst(Filter2,63,sr);
 StrLCopy(Filter2,Filter2,StrLen(Filter2)-StrLen(StrRScan(Filter2,'\'))+1);
 StrCopy(renamedat,'');
 StartConversion:=True;
end;

destructor TFJOWin.Done;
begin
 StartConversion:=false;
 KillTimer(HWindow,id_Timer);
 Edit[5]^.GetText(Filter,512);
 If not WriteProfileString(AppName,'Path',Filter)then
   MessageBox(HWindow,'error during modifing win.ini',AppName,mb_Ok or mb_SystemModal);
 TWindow2.Done;
end;

procedure TFJOWin.Batch;
begin
 If FindWindow(NIL,'LAME')<>0then
 begin
   MessageBox(HWindow,'LAME already running',AppName,mb_Ok or mb_IconExclamation);
   Exit;
 end;
 Edit[5]^.GetText(Filter,512);
 If(StrComp(Filter,'')=0)or(StrComp(Filter,'n/a')=0)then
 begin
   If MessageBox(HWindow,'first you have to specify a path to LAME.EXE',AppName,mb_OkCancel or mb_IconExclamation)=id_Ok
      then Lame(msg)else Exit;
   Edit[5]^.GetText(Filter,512);
   If StrComp(Filter,'')=0then Exit;
 end;
 Edit[1]^.GetText(Filter,512);
 If StrComp(Filter,'')=0then
 begin
   OpenInput(msg);
   Edit[1]^.GetText(Filter,512);
   If StrComp(Filter,'')=0then
   begin
     MessageBox(HWindow,'sorry, but you have to specify a valid input pcm file before starting any conversion',AppName,
                mb_Ok or mb_IconExclamation);
     Exit;
   end;
 end;
 If StrRScan(Filter,'\')<>NIL then
 begin
   StrLCopy(Filter,Filter,StrLen(Filter)-StrLen(StrRScan(Filter,'\'))+1);
   StrCat(Filter,'*.WAV');
   Edit[1]^.SetText(Filter);
 end;
end;

procedure TFJOWin.Lame;
var temp : CharArr;
begin
 If FindWindow(NIL,'LAME')<>0then
 begin
   MessageBox(HWindow,'LAME already running',AppName,mb_Ok or mb_IconExclamation);
   Exit;
 end;
 StrCopy(temp,FullFileName);
 StrCopy(FullFileName,'');
 FillChar(Filter,SizeOf(Filter),#0);  { Set up for double null at end }
 StrCopy(Filter,'Lame executable');
  StrCopy(@Filter[StrLen(Filter)+1],'lame.exe');
  FillChar(OpenFN,SizeOf(TOpenFileName),#0);
  with OpenFN do
  begin
    hInstance:=HInstance;
    hwndOwner:=HWindow;
    lpstrDefExt:='exe';
    lpstrFile:=FullFileName;
    lpstrFilter:=Filter;
    lpstrFileTitle:=FileName;
    flags:=ofn_FileMustExist;
    lStructSize:=sizeof(TOpenFileName);
    nFilterIndex:=1;
    nMaxFile:=SizeOf(FullFileName);
  end;
  If GetOpenFileName(OpenFN)then Edit[5]^.SetText(FullFileName);
  StrCopy(FullFileName,temp);
end;

procedure TFJOWin.OpenInput;
begin
 If FindWindow(NIL,'LAME')<>0then
 begin
   MessageBox(HWindow,'LAME already running',AppName,mb_Ok or mb_IconExclamation);
   Exit;
 end;
  StrCopy(FullFileName,'');
  FillChar(Filter,SizeOf(Filter),#0);  { Set up for double null at end }
  StrCopy(Filter,'PCM files');
  StrCopy(@Filter[StrLen(Filter)+1],'*.wav');
  FillChar(OpenFN,SizeOf(TOpenFileName),#0);
  with OpenFN do
  begin
    hInstance:=HInstance;
    hwndOwner:=HWindow;
    lpstrDefExt:='wav';
    lpstrFile:=FullFileName;
    lpstrFilter:=Filter;
    lpstrFileTitle:=FileName;
    flags:=ofn_FileMustExist;
    lStructSize:=sizeof(TOpenFileName);
    nFilterIndex:=1;
    nMaxFile:=SizeOf(FullFileName);
  end;
  If GetOpenFileName(OpenFN)then
  begin
    StrCopy(Filter,short2long(FullFileName));
    Edit[1]^.SetText(Filter);
  end;
end;

constructor TFJOWIn.Init;
const li:LongInt=0;
begin
 TextColor:=RGB(0,0,0);
 WindowColor:=RGB(192,192,192);
 TWindow2.Init(AParent,ATitle);
 li:=FindWindow(NIL,AppName);
 If(li<>0)and(li<>HWindow)then
 begin
   ShowWindow(li,sw_ShowNA);
   With Attr do
   begin
     x:=-1000;
     y:=x;
   end;
   PostQuitMessage(0);
 end;
 With Attr do
 begin
   h:=473;
   w:=747;
 end;
 GroupBox:=new(PGroupBox,init(@Self,id_dummy,'input',10,10,350,60));
 Edit[1]:=new(PEdit,init(@Self,id_dummy,'',20,32,310,25,0,false));
 Edit[1]^.Attr.Style:=Edit[1]^.Attr.Style or es_MultiLine;
 Edit[1]^.Attr.ExStyle:=512;
 Button:=new(PButton,init(@Self,id_Open,'...',332,37,20,15,false));

 GroupBox:=new(PGroupBox,init(@Self,id_dummy,'general',10,80,350,160));
 Button:=new(PButton,init(@Self,id_Batch,'make batch',20,105,80,20,false));
 Button:=new(PButton,init(@Self,id_Start,'start',120,105,80,20,true));
 PS:=new(PStatic,init(@Self,id_dummy,'lame location:',20,140,100,20,0));
 Edit[5]:=new(PEdit,init(@Self,id_dummy,'n/a',120,137,210,25,0,false));
 Edit[5]^.Attr.ExStyle:=512;
 Button:=new(PButton,init(@Self,id_Lame,'...',332,142,20,15,false));
 PS:=new(PStatic,init(@Self,id_dummy,'lame priority (0=idle, 4=highest):',20,180,210,20,0));
 PS2:=new(PStatic,init(@Self,id_dummy,'4',234,180,10,20,0));
 PBar:=new(PScrollBar,init(@Self,id_dummy,251,180,100,0,true));
 PBar^.PageMagnitude:=2;
 CheckBox[10]:=new(PCheckBox,init(@Self,id_dummy,'replace original',20,210,150,20,nil));
 CheckBox[11]:=new(PCheckBox,init(@Self,id_dummy,'permit screensaver',200,210,150,20,nil));

 GroupBox:=new(PGroupBox,init(@Self,id_dummy,'output',380,10,350,425));

 GroupBox:=new(PGroupBox,init(@Self,id_dummy,'quality settings',390,55,330,175));
 GroupBox:=new(PGroupBox,init(@Self,id_dummy,'mode',400,75,310,80));
 RadioButton[0]:=new(PRadioButton,init(@Self,id_dummy,'mono',420,100,120,20,nil));
 RadioButton[1]:=new(PRadioButton,init(@Self,id_dummy,'stereo',570,100,120,20,nil));
 RadioButton[2]:=new(PRadioButton,init(@Self,id_dummy,'joint stereo',420,125,120,20,nil));
 RadioButton[3]:=new(PRadioButton,init(@Self,id_dummy,'mid/side stereo',570,125,120,20,nil));
 CheckBox[0]:=new(PCheckBox,init(@Self,id_dummy,'disable psycho-accoustics',522,170,190,20,nil));
 CheckBox[1]:=new(PCheckBox,init(@Self,id_dummy,'disable band 21 cutoff',522,200,190,20,nil));
 CheckBox[2]:=new(PCheckBox,init(@Self,id_dummy,'allow block types',401,200,110,20,nil));
 CheckBox[3]:=new(PCheckBox,init(@Self,id_dummy,'higher quality',401,170,110,20,nil));
 PS:=new(PStatic,init(@Self,id_dummy,'bitrate [kbps] (vbr min. bitrate):',391,32,200,20,0));
 Edit[3]:=new(PEdit,init(@Self,id_dummy,'',597,29,123,25,0,false));
 Edit[3]^.Attr.ExStyle:=512;

 GroupBox:=new(PGroupBox,init(@Self,id_dummy,'variable bit rate',390,240,330,90));
 CheckBox[4]:=new(PCheckBox,init(@Self,id_dummy,'enable vbr',400,265,100,20,nil));
 PS:=new(PStatic,init(@Self,id_dummy,'quality (0=highest, 9=lowest):',400,295,190,20,0));
 Edit[2]:=new(PEdit,init(@Self,id_dummy,'0',600,292,100,25,0,false));
 Edit[2]^.Attr.ExStyle:=512;
 CheckBox[5]:=new(PCheckBox,init(@Self,id_dummy,'resample [kHz]: ',391,345,120,20,nil));
 Edit[4]:=new(PEdit,init(@Self,id_dummy,'48',510,342,100,25,0,false));
 Edit[4]^.Attr.ExStyle:=512;
 CheckBox[6]:=new(PCheckBox,init(@Self,id_dummy,'swap bytes',391,380,150,20,nil));
 CheckBox[7]:=new(PCheckBox,init(@Self,id_dummy,'CRC error protection',560,380,150,20,nil));
 CheckBox[8]:=new(PCheckBox,init(@Self,id_dummy,'mark as copyrighted',391,405,150,20,nil));
 CheckBox[9]:=new(PCheckBox,init(@Self,id_dummy,'mark as copy',560,405,150,20,nil));

 GroupBox:=new(PGroupBox,init(@Self,id_dummy,'MPEG1',10,250,350,85));
 PS:=new(PStatic,init(@Self,id_dummy,rates[0],20,272,330,30,0));
 PS:=new(PStatic,init(@Self,id_dummy,rates[1],20,292,330,30,0));
 GroupBox:=new(PGroupBox,init(@Self,id_dummy,'MPEG2',10,350,350,85));
 PS:=new(PStatic,init(@Self,id_dummy,rates[2],20,372,330,30,0));
 PS:=new(PStatic,init(@Self,id_dummy,rates[3],20,392,330,30,0));
end;

procedure TFJOWin.SetupWindow;
begin
 TWindow2.SetupWindow;
 GetProfileString(AppName,'Path','lame.exe',Filter,512);
 Edit[5]^.SetText(Filter);
 RadioButton[0]^.SetCheck(0);
 RadioButton[1]^.SetCheck(1);
 RadioButton[2]^.SetCheck(0);
 RadioButton[3]^.SetCheck(0);
 CheckBox[0]^.SetCheck(0);
 CheckBox[1]^.SetCheck(0);
 CheckBox[2]^.SetCheck(0);
 CheckBox[3]^.SetCheck(1);
 CheckBox[4]^.SetCheck(1);
 CheckBox[5]^.Disable;
 CheckBox[6]^.SetCheck(0);
 CheckBox[7]^.SetCheck(1);
 CheckBox[8]^.SetCheck(0);
 CheckBox[9]^.SetCheck(0);
 Edit[1]^.Disable;
 Edit[4]^.Disable;
 Edit[5]^.Disable;
 PBar^.SetRange(0,4);
 PBar^.SetPosition(4);
 CalculateCommand;
 SetTimer(HWindow,id_Timer,100,NIL);
end;

procedure TFJOWin.CalculateCommand;
var temp : CharArr;
    r : Real;
    code : Integer;
begin
 Edit[5]^.GetText(thecommand,512);
 If RadioButton[0]^.GetCheck=bf_Checked then Strcat(thecommand,' -m m')
  else
 if RadioButton[1]^.GetCheck=bf_Checked then Strcat(thecommand,' -m s')
  else
 if RadioButton[2]^.GetCheck=bf_Checked then Strcat(thecommand,' -m j')
  else
 if RadioButton[3]^.GetCheck=bf_Checked then Strcat(thecommand,' -m f');
 If CheckBox[0]^.GetCheck=bf_Checked then Strcat(thecommand,' -f');
 If CheckBox[1]^.GetCheck=bf_Checked then Strcat(thecommand,' -k');
 If CheckBox[2]^.GetCheck=bf_Checked then Strcat(thecommand,' -d');
 If CheckBox[3]^.GetCheck=bf_Checked then Strcat(thecommand,' -h');
 If CheckBox[4]^.GetCheck=bf_Checked then
 begin
   Strcat(thecommand,' -v');
   Edit[2]^.GetText(temp,512);
   If StrComp(temp,'')<>0then
   begin
     val(temp,r,code);
     If code=0then
     begin
       Strcat(thecommand,' -V ');
       Strcat(thecommand,temp);
     end
      else
     begin
       Strcopy(thecommand,'!!! ERROR at vbr quality settings: only numeric values are allowed');
       PS^.SetText(thecommand);
       Exit;
     end;
   end;
 end;
 Edit[3]^.GetText(temp,512);
 If StrComp(temp,'')<>0then
 begin
   val(temp,r,code);
   If code=0then
   begin
     Strcat(thecommand,' -b ');
     Strcat(thecommand,temp);
   end
    else
   begin
     Strcopy(thecommand,'!!! ERROR at bitrate settings: only numeric values are allowed');
     PS^.SetText(thecommand);
     Exit;
   end;
 end;
 If CheckBox[5]^.GetCheck=bf_Checked then
 begin
   Edit[4]^.GetText(temp,512);
   If StrComp(temp,'')<>0then
   begin
     val(temp,r,code);
     If code=0then
     begin
       Strcat(thecommand,' --resample ');
       Strcat(thecommand,temp);
     end
      else
     begin
       Strcopy(thecommand,'!!! ERROR at resample settings: only numeric values are allowed');
       PS^.SetText(thecommand);
       Exit;
     end;
   end;
 end;
 If CheckBox[6]^.GetCheck=bf_Checked then Strcat(thecommand,' -x');
 If CheckBox[7]^.GetCheck=bf_Checked then Strcat(thecommand,' -p');
 If CheckBox[8]^.GetCheck=bf_Checked then Strcat(thecommand,' -c');
 If CheckBox[9]^.GetCheck=bf_Checked then Strcat(thecommand,' -o');
end;

{$i winfelix.inc}
BEGIN
 RunApplication;
END.