UNIT FJOFAT32;

INTERFACE

 const long_readonly = 1;
       long_hidden = 2;
       long_system = 4;
       long_volume = 8;
       long_directory = 16;
       long_archive = 32;

 type chararr = array[0..259]of char;
      qword = array[0..7]of byte;
      long_SearchRec = record
                         attr : longint;
                         filecreationtime,
                         lastaccess,
                         lastmodification,
                         size,
                         reserved : qword;
                         fullname : chararr;
                         shortname : array[0..13]of char;
                         handle : Word;
                       end;

 var long_err : Boolean;


 function long_GetCurDir ( byteDrive : Byte ) : pchar;
 procedure long_FindFirst ( name : pchar; mask : byte; var sr : long_SearchRec );
 procedure long_FindNext ( var sr : long_SearchRec );
 function long2short ( name : chararr ) : pchar;
 function long_ChDir ( name : chararr ) : boolean;
 procedure long_Rename ( oldname, newname : chararr );
 function short2long ( name : chararr ) : pchar;
 procedure long_Erase ( name : chararr );

IMPLEMENTATION

 uses WinDos,Strings;
 const longintr = $21;
 var regs : TRegisters;
     tempstr,tempstr2 : chararr;

 function long_GetCurDir;
 var s:string;
 begin
  getcurdir(tempstr,0);
  s:=StrPas(tempstr);
  s:=s[1];
  regs.ax:=$7147;
  regs.dl:=byteDrive;
  regs.ds:=seg(tempstr2);
  regs.si:=ofs(tempstr2);
  intr(longintr,regs);
  strpcopy(tempstr,s);
  strcat(tempstr,':\');
  strcat(tempstr,tempstr2);
  long_getcurdir:=pchar(@tempstr);
 end;

 procedure long_FindFirst;
 begin
  regs.ax:=$714E;
  regs.cl:=mask;
  regs.ch:=0;
  regs.si:=0;
  regs.ds:=seg(name^);
  regs.dx:=ofs(name^);
  regs.es:=seg(sr);
  regs.di:=ofs(sr);
  intr(longintr,regs);
  sr.handle:=regs.ax;
  long_err:=odd(regs.flags);
 end;

 procedure long_FindNext;
 begin
  regs.ax:=$714F;
  regs.bx:=sr.handle;
  regs.si:=0;
  regs.es:=seg(sr);
  regs.di:=ofs(sr);
  intr(longintr,regs);
  long_err:=odd(regs.flags);
 end;

 function long2short;
 begin
  regs.ax:=$7160;
  regs.cl:=1;
  regs.ch:=0;
  regs.ds:=seg(name);
  regs.si:=ofs(name);
  regs.es:=seg(tempstr);
  regs.di:=ofs(tempstr);
  intr(longintr,regs);
  long_err:=odd(regs.flags);
  long2short:=pchar(@tempstr);
 end;

 function long_ChDir;
 begin
  regs.ax:=$713B;
  regs.ds:=seg(name);
  regs.dx:=ofs(name);
  intr(longintr,regs);
  long_ChDir:=not odd(regs.flags);
 end;

 procedure long_Rename;
 begin
  regs.ax:=$7156;
  regs.ds:=seg(oldname);
  regs.dx:=ofs(oldname);
  regs.es:=seg(newname);
  regs.di:=ofs(newname);
  intr(longintr,regs);
  long_err:=odd(regs.flags);
 end;

function short2long;
 begin
  regs.ax:=$7160;
  regs.cl:=$02;
  regs.ch:=0;
  regs.ds:=seg(name);
  regs.si:=ofs(name);
  regs.es:=seg(tempstr);
  regs.di:=ofs(tempstr);
  intr(longintr,regs);
  long_err:=odd(regs.flags);
  short2long:=pchar(@tempstr);
 end;

procedure long_Erase;
begin
 regs.ax:=$7141;
 regs.ds:=seg(name);
 regs.dx:=ofs(name);
 regs.si:=0;
 regs.cx:=0;
 intr(longintr,regs);
 long_err:=odd(regs.flags);
end;
end.