PROGRAM DOS2UNIX;
{$R DOS2UNIX}
USES WinDos,WinFelix,WinProcs,ODialogs,OWindows,WinTypes,FJOFAT32,CommDlg,Strings;
CONST APPNAME = 'DOS2UNIX';
      EXENAME = APPNAME;

      CM_CONVERT = 1001;
      CM_OPENCONVERTCLOSE = 1002;
      CM_CLOSE = 1003;
      CM_ABOUT = 1004;

TYPE PFJOWin = ^TFJOWin;
     TFJOWin = object(TWindow2)
                 Buffer : Array[0..9999]of Char;
                 OpenFN : TOpenFileName;
                 FullFileName,Filter,FileName : CharArr;
                 constructor Init ( AParent : PWindowsObject; ATitle : PChar );
                 function Convert ( var MSG : TMessage ) : Boolean; virtual CM_FIRST + CM_CONVERT;
                 procedure OpenConvertClose ( var MSG : TMessage ); virtual CM_FIRST + CM_OPENCONVERTCLOSE;
                 procedure cmAbout ( var MSG : TMessage ); virtual CM_FIRST + CM_ABOUT;
                 procedure cmClose ( var MSG : TMessage ); virtual CM_FIRST + CM_CLOSE;
                 function DoIt ( rw : Boolean ) : LongInt; virtual;
                 procedure GetWindowClass ( var AWndClass: TWndClass ); virtual;
                 procedure SetupWindow; virtual;
               end;

constructor TFJOWin.Init;
begin
 TextColor:=RGB(0,0,0);
 WindowColor:=RGB(192,192,192);
 TWindow2.Init(AParent,ATitle);
 With Attr do
 begin
   h:=50; w:=150;
 end;
end;

function TFJOWin.DoIt;
var InFile,OutFile : File;
    err,j : Word;
    convs : LongInt;
begin
 Assign(InFile,FullFileName);
 {$I-}Reset(InFile,1);{$I+}
 If IOResult<>0then
 begin
   StrCopy(Buffer,short2long(FullFileName));
   StrCat(Buffer,' konnte nicht geffnet werden.');
   MessageBox(HWindow,Buffer,AppName,0);
   DoIt:=-1;
   Exit;
 end;
 If rw then
 begin
   StrCopy(Buffer,FullFileName);
   Buffer[StrLen(Buffer)-1]:='~';
   Assign(OutFile,Buffer);
   {$I-}Rewrite(OutFile,1);{$I+}
   If IOResult<>0then
   begin
     MessageBox(HWindow,'Temporre Datei konnte nicht angelegt werden.',AppName,0);
     DoIt:=-1;
     Exit;
   end;
 end;
 convs:=0;
 Repeat
   Blockread(InFile,Buffer,10000,err);
   i:=0;
   While i<err-convs do
   begin
     If Buffer[i]=#13then
     begin
       convs:=convs+1;
       Move(Buffer[i+1],Buffer[i],err-i-1);
     end
      else
     inc(i);
   end;
   If rw then Blockwrite(OutFile,Buffer,err-convs);
 Until err<>10000;
 Close(InFile);
 DoIt:=convs;
 If rw then
 begin
   Close(OutFile);
   Erase(InFile);
   Rewrite(InFile,1);
   Reset(OutFile,1);
   Repeat
     Blockread(OutFile,Buffer,10000,err);
     Blockwrite(InFile,Buffer,err);
   Until err<>10000;
   Close(Infile);
   Close(OutFile);
   Erase(OutFile);
 end;
end;

function TFJOWin.Convert;
begin
 StrCopy(FullFileName,'');
 FillChar(Filter,SizeOf(Filter),#0);
 StrCopy(Filter,'alle Dateien');
 StrCopy(@Filter[StrLen(Filter)+1],'*.*');
 FillChar(OpenFN,SizeOf(TOpenFileName),#0);
 with OpenFN do
 begin
   hInstance:=HInstance;
   hwndOwner:=HWindow;
   lpstrDefExt:='*';
   lpstrFile:=FullFileName;
   lpstrFilter:=Filter;
   lpstrFileTitle:=FileName;
   flags:=ofn_FileMustExist;
   lStructSize:=sizeof(TOpenFileName);
   nFilterIndex:=1;
   nMaxFile:=SizeOf(FullFileName);
 end;
 Convert:=FALSE;
 If GetOpenFileName(OpenFN)then
 begin
   i:=DoIt(false);
   Case i of
        -1:;
        0: begin
             StrCopy(FileName,short2long(FileName));
             StrCat(FileName,' enthlt kein Linefeed (LF, ASCII-Code 13).'#13#10'Eine Konvertierung ist daher unntig.');
             MessageBox(HWindow,FileName,AppName,mb_Ok+mb_IconInformation);
           end;
        1: If MessageBox(HWindow,'1 Ersetzung kann vorgenommen werden.',AppName,mb_OkCancel)=id_Ok then Convert:=DoIt(true)>0;
        else
        begin
          StrCopy(FileName,i2pc(i));
          StrCat(FileName,' Ersetzungen knnen vorgenommen werden.');
          If MessageBox(HWindow,FileName,AppName,mb_OkCancel)=id_Ok then Convert:=DoIt(true)>0;
        end;
   end;
 end;
end;

procedure TFJOWin.OpenConvertClose;
begin
 If Convert(MSG)then Done;
end;

procedure TFJOWin.cmClose;
begin
 Done;
end;

procedure TFJOWin.cmAbout;
begin
  About;
end;

procedure TFJOWin.GetWindowClass;
begin
 inherited GetWindowClass(AWndClass);
 AWndClass.lpszMenuName:='MENU_1';
end;

procedure TFJOWin.SetupWindow;
var temp,Param : CharArr;
begin
 inherited SetupWindow;
 If ParamCount>0then
 begin
  ShowWindow(HWindow,sw_Hide);
  StrCopy(Param,'');
  For i:=1to ParamCount do
  begin
    StrPCopy(temp,ParamStr(i));
    StrCat(Param,temp);
    StrCat(Param,#32);
  end;
  StrCopy(FullFileName,long2short(Param));
  If StrComp(FullFileName,'')=0then StrCopy(FullFileName,Param);
  DoIt(true);
  PostQuitMessage(0);
 end;
end;

{$I WinFelix.inc}
procedure TFJOApp.InitInstance;
begin
 inherited InitInstance;
end;

BEGIN
 RunApplication;
END.