UNIT WinFelix;

INTERFACE

USES ODialogs,OWindows,WinTypes,WinProcs,Strings;
{$R WINFELIX}

TYPE CharArr = Array[0..1023]of Char;

CONST ws_Ex_AlwaysOnTop = 8;
{*$efaafa: erzeugt titelleiste
 $fffffca0: fenster nicht klickbar auerhalb
 exstyle's : 512 oder 4096*32}
      id_ShowMinimized = 61472;
      id_ShowRestored = 61728;
      id_Moved = 61458;
      id_About = 10000;
      id_Icon1 = 10001;
      id_Icon2 = 10003;
      id_Icon3 = 10004;
      id_email = 1005;
      id_Dummy = 32767;
      id_ScreenSaver = 61760;
      id_ApplExit = 61536;

      Day_of_Week : Array[0..6]of CharArr = ('Sonntag','Montag','Dienstag','Mittwoch','Donnerstag','Freitag','Samstag');
      Month_of_Year : Array[1..12]of CharArr = ('Januar','Februar','Mrz','April','Mai','Juni','Juli',
                                                'August','September','Oktober','November','Dezember');

TYPE PDialog2 = ^TDialog2;
     TDialog2 = object(TDialog)
                      procedure email (var MSG:TMESSAGE);virtual id_First+id_email;
                end;

     PWindow2 = ^TWindow2;
     TWindow2 = object(TWindow)
                      SysMenu : HMenu;
                      WindowColor,TextColor : LongInt;
                      AllowScreenSaver : Boolean;
                      constructor Init(AParent: PWindowsObject; ATitle: PChar);
                      destructor Done;virtual;
                      procedure WMControlColor(var Msg: TMessage);virtual wm_First + wm_CtlColor;
                      procedure Paint ( PaintDC : HDC; Var PaintInfo : TPaintStruct );virtual;
                      procedure SetupWindow;virtual;
{                      procedure SysMenue(VAR MSG:TMESSAGE);virtual wm_sysCommand;}
                      procedure DefWndProc (var MSG:TMESSAGE);virtual;
                      procedure GetWindowClass(var WndClass: TWndClass);virtual;
                      procedure About;virtual;
                      procedure RedefineColors ( NewWindowColor,NewTextColor : LongInt );
                    private
                      WindowRect : TRect;
                      WindowBrush : HBrush;

                end;

VAR ConvertTemp : CharArr;
    i : LongInt;
    err : Word;

function I2S ( ii : LongInt ) : String;
function S2I ( is : String ) : LongInt;
function I2PC ( ii : LongInt ) : PChar;
function PC2I ( ip : PChar ) : LongInt;
function S2PC ( is : String ) : PChar;
function UP ( _is : String ) : String;

IMPLEMENTATION

function UP;
var _tmp : byte;
begin
 for _tmp:=1to length(_is)do _is[_tmp]:=UPCASE(_is[_tmp]);
 UP:=_is;
end;

procedure TDialog2.email;
begin
 WinExec('start mailto:Felix.J.Ogris@gmx.net',sw_ShowMinimized);
 EndDlg(1);
end;

procedure TWindow2.RedefineColors;
begin
 WindowColor:=NewWindowColor;
 WindowBrush:=CreateSolidBrush(WindowColor);
 TextColor:=NewTextColor;
 SetTextColor(GetDC(HWindow),TextColor);
end;

procedure TWindow2.GetWindowClass;
begin
 TWindow.GetWindowClass(WndClass);
 WndClass.hIcon:=LoadIcon(HInstance,PChar(id_Icon1));
end;

procedure TWindow2.About;
begin
 Application^.ExecDialog(New(PDialog2,Init(@Self,PChar(10002))));
end;

procedure TWindow2.DefWndProc;
begin
 If Msg.Message=wm_sysCommand then
 Case Msg.wParam of
      id_About: About;
      id_ScreenSaver: If AllowScreenSaver then TWindow.DefWndProc(Msg);
      else TWindow.DefWndProc(Msg);
  end
  else TWindow.DefWndProc(Msg);
end;

constructor TWindow2.Init;
begin
 TWindow.Init(AParent,ATitle);
 Attr.Style:=Attr.Style and not ws_MaximizeBox and not ws_ThickFrame and not ws_Border;
 WindowBrush:=CreateSolidBrush(WindowColor);
 AllowScreenSaver:=true;
end;

destructor TWindow2.Done;
begin
 DeleteObject(WindowBrush);
 TWindow.Done;
end;

procedure TWindow2.SetupWindow;
begin
 TWindow.SetupWindow;
 SysMenu:=GetSystemMenu(HWindow,false);
 DeleteMenu(SysMenu,2,mf_byPosition or mf_SysMenu);
 DeleteMenu(SysMenu,3,mf_byPosition or mf_SysMenu);
 InsertMenu(SysMenu,5,mf_byPosition or mf_Separator or mf_SysMenu,id_Dummy,NIL);
 InsertMenu(SysMenu,6,mf_byPosition or mf_String or mf_SysMenu,id_About,'&About');
end;

procedure TWindow2.WMControlColor(var Msg: TMessage);
begin
 SetTextColor(Msg.WParam,TextColor);
 SetBkMode(Msg.WParam,transparent);
 case Msg.LParamHi of
      ctlcolor_Btn,
      ctlcolor_Dlg,
      ctlcolor_Edit,
      ctlcolor_ListBox,
      ctlcolor_MsgBox,
      ctlcolor_ScrollBar,
      ctlcolor_Static: Msg.Result:=WindowBrush;
      else DefWndProc(Msg);
  end;
end;

procedure TWindow2.Paint;
begin
 GetClientRect(HWindow,WindowRect);
 FillRect(PaintDC,WindowRect,WindowBrush);
end;

function I2S ( ii : LongInt ) : String;
var tmp : String;
begin
 str(ii,tmp);
 I2S:=tmp;
end;

function PC2I ( ip : PChar ) : LongInt;
begin
 PC2I:=S2I(StrPas(ip));
end;

function S2I ( is : String ) : LongInt;
var tmp : LongInt;
begin
 val(is,tmp,err);
 If err<>0then tmp:=0;
 S2I:=tmp;
end;

function I2PC ( ii : LongInt ) : PChar;
begin
 StrPCopy(ConvertTemp,I2S(ii));
 I2PC:=ConvertTemp;
end;

function S2PC;
begin
 StrPCopy(ConvertTemp,is);
 S2PC:=ConvertTemp;
end;

END.