.model flat,pascal
.486p

EXTRN Vendor   : DWord     ; String(12) = 13 bytes
EXTRN Stepping : DWord     ; Byte
EXTRN Modell   : DWord     ; Byte
EXTRN Family   : DWord     ; Byte
EXTRN FPU      : Byte     ; Boolean
EXTRN MMX      : Byte     ; Boolean
EXTRN K63DNow  : Byte     ; Boolean
EXTRN TSC      : DWord    ; QuadWord

.CODE

public TimeStampCounter
public TestCPUID
public SuperVendor


RDTSC macro
   db 0Fh, 31h
endm

CPUID macro
   db 0fh, 0A2h
endm

TimeStampCounter proc near
   RDTSC
   mov  [TSC],edx
   mov  [TSC+4],eax
   ret
TimeStampCounter endp

SuperVendor proc near
; zunchst testen ob CPUID erlaubt

   pushfd                 ; save EFLAGS
   pop    eax             ; EFLAGS ins EAX-Register
   mov    ebx,eax         ; merken in EBX
   xor    eax,00200000h   ; toggle Bit 21
   push   eax             ; und via stack
   popfd                  ; ins EFLAGS-Register
   pushfd                 ; Von dort wieder via Stack
   pop    eax             ; zurck  nach EAX
   cmp    eax,ebx         ; Hat sich Bit 21 gendert?
   jz     @@err_exit1     ; nein => no CPUID

; jetzt den Vendorstring ber eax=0 abrufen

   mov    eax,0
   CPUID
   mov    [Vendor],12     ; String(12)
   mov    [Vendor+1],ebx
   mov    [Vendor+5],edx
   mov    [Vendor+9],ecx

; nun die Standard Prozessor Signatur ber eax=1 abrufen

   mov    eax,1
   CPUID
   xor    ebx,ebx
   mov    ebx,eax
   shl    ebx,28
   shr    ebx,28
   mov    [Stepping],ebx
   mov    ebx,eax
   shl    ebx,24
   shr    ebx,28
   mov    [Modell],ebx
   mov    ebx,eax
   shl    ebx,20
   shr    ebx,28
   mov    [Family],ebx

; das Standard feature flag in edx auswerten

   mov    [FPU],0         ; alles false setzen
   mov    [MMX],0
   mov    [K63dNow],0
   test   edx,1b          ; Bit 0 gesetzt?
   jz     @@jump1         ; nein => keine FPU
   mov    [FPU],1
@@jump1:
   test   edx,100000000000000000000000b ; Bit 23 gesetzt?
   jz     @@jump2         ; nein => kein MMX
   mov    [MMX],1
@@jump2:

; jetzt AMD Processor Signature und extended feature flags ber eax=80000001h
; aufrufen

   mov    eax,80000001h
   CPUID

; nun Test auf 3DNow

   test   edx,10000000000000000000000000000000b ; Bit 31 gesetzt?
   jz     @@jump3         ; nein => kein 3DNow
   mov    [K63DNow],1

@@jump3:
   mov    ax,0            ; alles ok
   ret                    ; und tschss
@@err_exit1:
   mov ax,1
   ret
SuperVendor endp


TestCPUID proc near
   pushfd              ; save EFLAGS
   pop eax             ; EFLAGS ins EAX-Register
   mov ebx, eax        ; merken in EBX
   xor eax, 00200000h  ; toggle Bit 21
   push eax            ; und via stack
   popfd               ; ins EFLAGS-Register
   pushfd              ; Von dort wieder via Stack
   pop eax             ; zurck  nach EAX
   cmp eax, ebx        ; Hat sich Bit 21 gendert?
   jz @@err_ext        ; nein => no CPUID
   mov ax,0
   ret
@@err_ext:
   mov ax,1
   ret
TestCPUID endp

end