/*
 * Decompiled with CFR 0.152.
 */
package tvhead2tvb;

import devplugin.ActionMenu;
import devplugin.Plugin;
import devplugin.PluginInfo;
import devplugin.Program;
import devplugin.SettingsTab;
import devplugin.Version;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import util.browserlauncher.Launch;

public final class Tvhead2TVB
extends Plugin
implements SettingsTab {
    private static final Version VERSION = new Version(1, 0, true);
    private static final PluginInfo INFO = new PluginInfo(Tvhead2TVB.class, "Tvhead2TVB", "Exports program schedules from TV-Browser to Tvheadend", "Felix J. Ogris (fjo@ogris.de)", "GPL", "http://ogris.de/tvhead2tvb");
    private boolean configured = false;
    private final JTextField tvheadUrlField = new JTextField();
    private String tvheadUrl;
    private final JPanel settingsPanel = new JPanel();
    private final long mainThreadId = Thread.currentThread().getId();

    public Tvhead2TVB() {
        JPanel serverPanel = new JPanel();
        serverPanel.setBorder(BorderFactory.createTitledBorder("Server settings"));
        JLabel urlLabel = new JLabel("Url:");
        GroupLayout serverLayout = new GroupLayout(serverPanel);
        serverLayout.setHorizontalGroup(serverLayout.createSequentialGroup().addGroup(serverLayout.createSequentialGroup().addComponent(urlLabel).addComponent(this.tvheadUrlField, -2, 200, Integer.MAX_VALUE)));
        serverLayout.setVerticalGroup(serverLayout.createSequentialGroup().addGroup(serverLayout.createBaselineGroup(false, false).addComponent(urlLabel).addComponent(this.tvheadUrlField)));
        serverPanel.setLayout(serverLayout);
        this.settingsPanel.setLayout(new BoxLayout(this.settingsPanel, 3));
        this.settingsPanel.add(serverPanel);
    }

    private void checkSettings(boolean showDialog) {
        this.configured = false;
        this.tvheadUrl = this.tvheadUrlField.getText();
        try {
            new URL(this.tvheadUrl).toURI();
        }
        catch (Exception e) {
            if (showDialog) {
                this.showError("Invalid Tvheadend url: " + this.tvheadUrl);
            }
            return;
        }
        this.configured = true;
    }

    private void showError(final String errMsg) {
        Runnable run = new Runnable(){

            @Override
            public final void run() {
                JOptionPane.showMessageDialog(null, errMsg, "Tvhead2TVB", 0);
            }
        };
        if (this.mainThreadId == Thread.currentThread().getId()) {
            run.run();
        } else {
            SwingUtilities.invokeLater(run);
        }
    }

    private void recordProgram(Program program) {
        String title;
        try {
            title = URLEncoder.encode(program.getTitle(), "UTF-8");
        }
        catch (Exception e) {
            title = program.getTitle();
        }
        Launch.openURL((String)(this.tvheadUrl + "/simple.html?s=" + title));
    }

    public final String getTitle() {
        return null;
    }

    public final Icon getIcon() {
        return null;
    }

    public JPanel createSettingsPanel() {
        this.tvheadUrlField.setText(this.tvheadUrl);
        return this.settingsPanel;
    }

    public void saveSettings() {
        this.checkSettings(true);
    }

    public final Properties storeSettings() {
        Properties settings = new Properties();
        settings.setProperty("tvheadUrl", this.tvheadUrl);
        return settings;
    }

    public final void loadSettings(Properties settings) {
        this.tvheadUrl = settings.getProperty("tvheadUrl", "http://tvheadend.local:9981");
        this.tvheadUrlField.setText(this.tvheadUrl);
        this.checkSettings(false);
    }

    public final SettingsTab getSettingsTab() {
        return this;
    }

    protected final String getMarkIconName() {
        return "tvhead2tvb.png";
    }

    public static Version getVersion() {
        return VERSION;
    }

    public final PluginInfo getInfo() {
        return INFO;
    }

    public final ActionMenu getContextMenuActions(final Program program) {
        String cmdConfigure = "Tvhead2TVB: Configure...";
        String cmdRecord = "Tvhead2TVB: Record";
        final Tvhead2TVB plugin = this;
        AbstractAction action = new AbstractAction(){

            @Override
            public final void actionPerformed(ActionEvent e) {
                String cmd = e.getActionCommand();
                if (cmd.equals("Tvhead2TVB: Configure...")) {
                    Plugin.getPluginManager().showSettings(plugin);
                } else if (cmd.equals("Tvhead2TVB: Record")) {
                    Tvhead2TVB.this.recordProgram(program);
                }
            }
        };
        action.putValue("SmallIcon", this.createImageIcon(this.getMarkIconName()));
        if (!this.configured) {
            action.putValue("Name", "Tvhead2TVB: Configure...");
        } else {
            action.putValue("Name", "Tvhead2TVB: Record");
        }
        return new ActionMenu((Action)action);
    }
}

