#include <stdlib.h>
#include <string.h>
#include "io.h"
#include "str.h"

int save_strcmp (const char *s1, const char *s2)
{
  if (!s1 || !s2) return -2;
  return strcmp(s1, s2);
}

size_t stralloc_cpy (char **dst, const char *src)
{
  static size_t len;

  if (!dst || !src) return 0;
  len = strlen(src);
  *dst = malloc(len + 1);
  if (!*dst) {
    _write2("stralloc_cpy: no memory");
    exit(1);
  }
  memmove(*dst, src, len + 1);
  return len;
}

size_t stralloc_cat (char **dst, const char *src)
{
  static size_t len;

  if (!dst || !src) return 0;
  if (!*dst) return stralloc_cpy(dst, src);
  len = strlen(*dst) + strlen(src);
  *dst = realloc(*dst, len + 1);
  if (!*dst) {
    _write2("stralloc_cat: no memory");
    exit(1);
  }
  strcat(*dst, src);
  return len;
}
