#include <unistd.h>
#include <stdlib.h>
#include <malloc.h>
#include <string.h>
#include "libpq-fe.h"
#include "io.h"
#include "str.h"
#include "cgi.h"
#include "db.h"
#include "squid_redir_conf.h"
#include "defs.h"

char *me;

void page_end ()
{
  _write1(PAGE_END);
}

void error (const char *err)
{
  _write1(ERROR_START);
  _write1(cgi_htmlmeta(err));
  _write1(ERROR_END);
}

void form (const char *src, const char *old_src, const char *dst,
           const char *title)
{
  _write1(FORM_START);
  _write1(me);
  _write1(FORM_POST H2_START);

  if (title) _write1(title);
  else _write1("New redirection");

  _write1(H2_END P_START INPUT_TXT_START "src" INPUT_TXT_VALUE);
  if (src) _write1(cgi_htmlmeta(src));

  _write1(INPUT_TXT_END ARROW INPUT_TXT_START "dst" INPUT_TXT_VALUE);
  if (dst) _write1(cgi_htmlmeta(dst));

  _write1(INPUT_TXT_END P_START P_END INPUT_SUBMIT P_END);
  if (old_src)
  {
    _write1(INPUT_HIDDEN_START "old_src" INPUT_HIDDEN_VALUE);
    _write1(cgi_htmlmeta(old_src));
    _write1(INPUT_HIDDEN_END P_START INPUT_CHCKBX_START "del" INPUT_CHCKBX_VALUE
      "del" INPUT_CHCKBX_END "Delete this redirection" P_END);
  }

  _write1(FORM_END);
  if (title) {
    _write1(P_START AHREF_START);
    _write1(me);
    _write1(AHREF_VALUE BACK AHREF_END P_END);
  }
}

void handle_post (PGconn *conn, char *src, char *old_src, char *dst,
                  char *del)
{
  PGresult *res;
  int i;
  char *buf;

  if (!src) {
    form(src, old_src, dst, "Please specify the original URL.");
    return;
  }
  if (!*src) {
    form(src, old_src, dst, "Please specify the original URL.");
    return;
  }
  if (!valid_url(src)) {
    form(src, old_src, dst, "The original URL is invalid.");
    return;
  }
  if (!dst) {
    form(src, old_src, dst, "Please specify the destination URL.");
    return;
  }
  if (!*dst) {
    form(src, old_src, dst, "Please specify the destination URL.");
    return;
  }
  if (!valid_url(dst)) {
    form(src, old_src, dst, "The destination URL is invalid.");
    return;
  }
  if (del) {
    if (strcmp(del, "del")) {
      _write1(P_START SMART P_END);
      return;
    }
  }
  if (old_src) {
    if (!*old_src || !valid_url(old_src)) {
      _write1(P_START SMART P_END);
      return;
    }
  }

  stralloc_cpy(&buf, "SELECT " DSTCOL " FROM " TABLE " WHERE "SRCCOL"='");
  stralloc_cat(&buf, src);
  if (del) {
    stralloc_cat(&buf, "' AND " DSTCOL "='");
    stralloc_cat(&buf, dst);
  }
  stralloc_cat(&buf, "';");
  res = PQexec(conn, buf);
  free(buf);
  if (PQresultStatus(res) != PGRES_TUPLES_OK) {
    buf = PQresultErrorMessage(res);
    PQclear(res);
    error(buf);
    return;
  }

  i = PQntuples(res);
  if (!i && del) {
    stralloc_cpy(&buf, "There is no redirection ");
    stralloc_cat(&buf, cgi_htmlmeta(src));
    stralloc_cat(&buf, ARROW);
    stralloc_cat(&buf, cgi_htmlmeta(dst));
    stralloc_cat(&buf, ".");
    form(src, old_src, dst, buf);
    PQclear(res);
    return;
  }

  if (i && !del && !old_src) {
    stralloc_cpy(&buf, "There is already a redirection ");
    stralloc_cat(&buf, cgi_htmlmeta(src));
    stralloc_cat(&buf, ARROW);
    stralloc_cat(&buf, cgi_htmlmeta(PQgetvalue(res, 0, PQfnumber(res,DSTCOL))));
    stralloc_cat(&buf, ".");
    form(src, old_src, dst, buf);
    PQclear(res);
    return;
  }

  PQclear(res);

  if (del) {
    stralloc_cpy(&buf, "DELETE FROM " TABLE " WHERE " SRCCOL "='");
    stralloc_cat(&buf, src);
    stralloc_cat(&buf, "' AND " DSTCOL "='");
    stralloc_cat(&buf, dst);
    stralloc_cat(&buf, "';");
  } else if (old_src) {
    stralloc_cpy(&buf, "UPDATE " TABLE " SET " SRCCOL "='");
    stralloc_cat(&buf, src);
    stralloc_cat(&buf, "', " DSTCOL "='");
    stralloc_cat(&buf, dst);
    stralloc_cat(&buf, "' WHERE " SRCCOL "='");
    stralloc_cat(&buf, old_src);
    stralloc_cat(&buf, "';");
  } else {
    stralloc_cpy(&buf, "INSERT INTO " TABLE " (" SRCCOL ","DSTCOL") VALUES ('");
    stralloc_cat(&buf, src);
    stralloc_cat(&buf, "','");
    stralloc_cat(&buf, dst);
    stralloc_cat(&buf, "');");
  }

  res = PQexec(conn, buf);
  free(buf);
  if (PQresultStatus(res) != PGRES_COMMAND_OK) {
    buf = PQresultErrorMessage(res);
    PQclear(res);
    error(buf);
    return;
  }
  PQclear(res);

#define ACTION (del)?("deleted"):((old_src)?("modified"):("inserted"))

  _write1(H2_START "Redirection ");
  _write1(ACTION);
  _write1(H2_END P_START "The redirection ");
  _write1(cgi_htmlmeta(src)); _write1(ARROW); _write1(cgi_htmlmeta(dst));
  _write1(" was successfully ");
  _write1(ACTION);
  _write1("." P_END P_START AHREF_START);
  _write1(me);
  _write1(AHREF_VALUE BACK AHREF_END P_END);
  return;
}

void handle_get_nourl (PGconn *conn)
{
  static PGresult *res;
  static int results, i, src, dst;

  _write1(H2_START "Redirections" H2_END);

  res = PQexec(conn, GETALL);
  if (PQresultStatus(res) != PGRES_TUPLES_OK) {
    error(PQresultErrorMessage(res));
    PQclear(res);
    return;
  }

  if (!(results = PQntuples(res))) {
    _write1(P_START "No redirections found." P_END);
    PQclear(res);
    form(NULL, NULL, NULL, NULL);
    return;
  }

  src = PQfnumber(res, SRCCOL);
  dst = PQfnumber(res, DSTCOL);

  _write1(TABLE_START);

  for (i = 0; i < results; ++i) {
    _write1(ROW_START COL_START);
    _write1(cgi_htmlmeta(PQgetvalue(res, i, src)));
    _write1(COL_END COL_START AHREF_START);
    _write1(me);
    _write1("?url=");
    _write1(cgi_htmlmeta(PQgetvalue(res, i, src)));
    _write1(AHREF_VALUE ARROW AHREF_END COL_END COL_START);
    _write1(cgi_htmlmeta(PQgetvalue(res, i, dst)));
    _write1(COL_END ROW_END);
  }

  _write1(TABLE_END);
  PQclear(res);
  form(NULL, NULL, NULL, NULL);
}

void handle_get (PGconn *conn, char *url)
{
  PGresult *res;
  char *buf;

  if (!url) {
    handle_get_nourl(conn);
    return;
  }
  if (!*url) {
    handle_get_nourl(conn);
    return;
  }
  if (!valid_url(url)) {
    _write1(P_START SMART P_END);
    return;
  }

  stralloc_cpy(&buf, "SELECT * FROM " TABLE " WHERE " SRCCOL "='");
  stralloc_cat(&buf, url);
  stralloc_cat(&buf, "';");
  res = PQexec(conn, buf);
  free(buf);
  if (PQresultStatus(res) != PGRES_TUPLES_OK) {
    error(PQresultErrorMessage(res));
    PQclear(res);
    return;
  }
  if (!PQntuples(res)) {
    _write1(H2_START "No such redirection" H2_END
      P_START "There is no redirection for ");
    _write1(cgi_htmlmeta(url));
    _write1("." P_END P_START AHREF_START);
    _write1(me);
    _write1(AHREF_VALUE BACK AHREF_END P_END);
    PQclear(res);
    return;
  }
  form(PQgetvalue(res, 0, PQfnumber(res, SRCCOL)),
    url,
    PQgetvalue(res, 0, PQfnumber(res, DSTCOL)),
    "Modify or delete this redirection.");
  PQclear(res);
}

int valid_url (char *url)
{
  if (!url) return 0;
  for (; *url; ++url) {
    if (!(
      ((*url >= 'A') && (*url <= 'Z')) ||
      ((*url >= 'a') && (*url <= 'z')) ||
      ((*url >= '0') && (*url <= '9')) ||
      (*url == '-') || (*url == ':') || (*url == '/') ||
      (*url == '.') || (*url == '_') || (*url == '?') ||
      (*url == '=') || (*url == '&') || (*url == '%') )) return 0;
  }
  return 1;
}

void die (char *why)
{
  if (why) error(why);
  else error("no memory");
  page_end();
  exit(1);
}

int main (int argc, char **argv)
{
  PGconn *conn;
  struct perlhash **args;
  char *err,
    *buf = NULL;

  if (strrchr(argv[0], '/')) stralloc_cpy(&me, strrchr(argv[0], '/') + 1);
  else stralloc_cpy(&me, argv[0]);

  _write1(PAGE_START);

  err = db_start(CONFIG, &conn, NULL);
  if (err) die(err);

  if (!save_strcmp(getenv("REQUEST_METHOD"), "POST")) {
    if (_read1(&buf) < 0) die(NULL);
    if (cgi_initargs(&args, buf) < 0) die(NULL);
    handle_post(conn, cgi_getvalue(args, "src"),
      cgi_getvalue(args, "old_src"), cgi_getvalue(args, "dst"),
      cgi_getvalue(args, "del"));
  }
  else {
    if (cgi_initargs(&args, getenv("QUERY_STRING")) < 0) die(NULL);
    handle_get(conn, cgi_getvalue(args, "url"));
  }

  PQfinish(conn);
  page_end();

  return 0;
}
