#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <sys/mman.h>
#include <fcntl.h>
#include <string.h>
#include <signal.h>
#include "libpq-fe.h"
#include "io.h"
#include "str.h"
#include "db.h"
#include "squid_redir.h"
#include "defs.h"

PGconn *conn = NULL;
char *bufsave = NULL;

void sig_handler (const int sig)
{
  if (conn) PQfinish(conn);
  if (bufsave) free(bufsave);
  exit(sig);
}

void print_error (const char *error_url, char *error)
{
  static char hex[16] = "0123456789ABCDEF";

  _write1((error_url)?(error_url):(ERROR_URL));
  _write1("?");
  for (; *error; ++error) {
    write(STDOUT, "%", 1);
    write(STDOUT, &hex[*error / 16], 1);
    write(STDOUT, &hex[*error % 16], 1);
  }
  _write1("\n");
}

int main ()
{
  PGresult *res;
  struct sigaction sa;
  int i;
  char buf[BUFFER_SIZE], *c, *p, *error_url;

  /* redirect all signal handlers */
  sa.sa_handler = &sig_handler;
  sa.sa_flags = 0;
  for (i = 0; i < SIGRTMAX; i++) sigaction(i, &sa, NULL);

  /* save a strcpy() each loop */
  c = &buf[0];
  strcpy(c, PRE_FIND_URL);
  c += strlen(PRE_FIND_URL);

  /* read url from STDIN, try to find it in the database, write url to STDOUT */
  for (;;) {
    i = read(STDIN, c, BUFFER_SIZE - 200);
    if (i < 0) {
      print_error(error_url, READ_ERROR);
      continue;
    }
    if (!i) break;
    *(c + i) = '\0';
    if ((p = strchr(c, ' '))) *p = '\0';
    if ((p = strchr(c, '\n'))) *p = '\0';
    if ((p = strchr(c, '\r'))) *p = '\0';
    i = strlen(c);
    if (!conn) {
      p = db_start(CONFIG, &conn, &error_url);
      if (p) {
        print_error(error_url, p);
        conn = NULL;
        continue;
      }
    }
 
    bufsave = realloc(bufsave, i + 1);
    strcpy(bufsave, c);
    PQescapeString(c, c, i);
    strcat(c, SUF_FIND_URL);
    res = PQexec(conn, &buf[0]);
    if (PQresultStatus(res) != PGRES_TUPLES_OK) {
      print_error(error_url, PQresultErrorMessage(res));
      PQclear(res);
      continue;
    }
    if (PQntuples(res) == 1) p = PQgetvalue(res, 0, PQfnumber(res, DSTCOL));
    else p = bufsave;
    PQclear(res);
    _write1(p); _write1("\n");
  }

  sig_handler(0);

  /* not reached */
  return 0;
}
