#include <unistd.h>
#include <stdlib.h>
#include "io.h"

void __write (const int fd, const char *s)
{
  if (s) write(fd, s, strlen(s));
  else write(fd, "[null]", 6);
}

void _write1 (const char *s)
{
  __write(STDOUT, s);
}

void _write2 (const char *s)
{
  __write(STDERR, s);
}

size_t _read1 (char **buf)
{
  static ssize_t i;
  static size_t len;

  if (!buf) return 0;
  for (len = 0;;) {
    len += BUFFER_SIZE;
    *buf = realloc(*buf, len);
    if (!*buf) return -1;
    i = read(STDIN, *buf + len - BUFFER_SIZE, BUFFER_SIZE);
    if (i < BUFFER_SIZE) {
      len += i - BUFFER_SIZE;
      *(*buf + len) = '\0';
      break;
    }
  }
  return len;
}
