#ifndef _CGI_H
#define _CGI_H

/*
 * types
 */

struct perlhash {
  char *key;
  char *value;
};


/*
 * how to escape some special HTML characters
 */

static struct perlhash htmlmeta[] = {
{ "&", "&amp;" },
{ "\"", "&quot;" },
{ "<", "&lt;" },
{ ">", "&gt;" },
{ "", "&Auml;" },
{ "", "&Ouml;" },
{ "", "&Uuml;" },
{ "", "&szlig;" },
{ "", "&auml;" },
{ "", "&ouml;" },
{ "", "&uuml;" },
{ NULL, NULL }
};


/*
 * prototypes
 */

char *cgi_htmlmeta (const char *old);
char *cgi_getvalue (struct perlhash **args, const char* key);
int cgi_initargs (struct perlhash ***args, char *query);

#endif
