#include <unistd.h>
#include <string.h>
#include <malloc.h>
#include "cgi.h"

/*
 * escape special characters which are unprintable in HTML
 */

char *cgi_htmlmeta (const char *old)
{
  static size_t len, vlen;
  static int i;
  static char *new = NULL, *p;

  if (!old) return NULL;
  len = strlen(old);
  new = realloc(new, len + 1);
  if (!new) return NULL;
  strcpy(new, old);
  for (i = 0; htmlmeta[i].key; ++i) {
    p = new;
    while ((p = strstr(p, htmlmeta[i].key))) {
      len += strlen(htmlmeta[i].value) - 1;
      ++p;
    }
  }
  new = realloc(new, len + 1);
  for (i = 0; (htmlmeta[i].key); ++i) {
    p = new;
    while ((p = strstr(p, htmlmeta[i].key))) {
      vlen = strlen(htmlmeta[i].value);
      memmove(p + vlen, p + 1, len - (p - new));
      memmove(p, htmlmeta[i].value, vlen);
      p += vlen;
    }
  }
  return new;
}


/*
 * like $hash{$key} in Perl
 */

char *cgi_getvalue (struct perlhash **args, const char* key)
{
  if (args)
    for (; *args; ++args) if (!strcmp(key, (*args)->key)) return (*args)->value;
  return NULL;
}


/*
 * is c in [0..9, A..F, a..f] ?
 */

int cgi_validhexchar (char c)
{
  return (
    ((c>='a') && (c<='f')) ||
    ((c>='A') && (c<='F')) ||
    ((c>='0') && (c<='9'))
  );
}


/*
 * hex to dec
 */

int cgi_hexchar2int (char c)
{
  if (c >= 'a') return (c - 'a' + 10);
  if (c >= 'A') return (c - 'A' + 10);
  return (c - '0');
}


/*
 * eg. %A7 => 
 */

void cgi_unescape (char *s)
{
  static char *c;

  for (c = s; (c = strchr(c, '%')); ++c) {
    if (strlen(c) < 3) continue;
    if (!cgi_validhexchar(*(c + 1)) || !cgi_validhexchar(*(c + 2))) continue;
    *c = cgi_hexchar2int(*(c + 1)) * 16 + cgi_hexchar2int(*(c + 2));
    memmove(c + 1, c + 3, strlen(c + 3) + 1);
  }
}


/*
 * fill in args using key/value pairs from query
 */

int cgi_initargs (struct perlhash ***args, char *query)
{
  int count = 0;
  char *key = query, *value, *next;

  *args = NULL;
  if (!query) return 0;

  cgi_unescape(query);

  do {
    next = strchr(key, '&');
    if (next) *next++ = '\0';

    value = strchr(key, '=');
    if (value) *value++ = '\0';

    *args = realloc(*args, (count + 2) * sizeof(struct perlhash*));
    if (!*args) return -1;

    (*args)[count] = malloc(sizeof(struct perlhash));
    if (!(*args)[count]) return -1;

    (*args)[count]->key = key;
    (*args)[count]->value = value;
    (*args)[++count] = NULL;

    key = next;
  } while (key);

  return count;
}
