CREATE TABLE graylist (
  hostname  VARCHAR(255) NOT NULL,
  ip        VARCHAR(39)  NOT NULL,
  username  VARCHAR(255) NOT NULL,
  sender    VARCHAR(255) NOT NULL,
  recipient VARCHAR(255) NOT NULL,
  count     INTEGER      NOT NULL,
  instance  VARCHAR(255) NOT NULL,
  ts_entry  DATETIME     NOT NULL,
  ts_latest DATETIME     NOT NULL,
  ts_ok     DATETIME,
  PRIMARY KEY (ip, sender, recipient)
);

CREATE TABLE mailcount (
  hostname  VARCHAR(255) NOT NULL,
  ip        VARCHAR(39)  NOT NULL,
  username  VARCHAR(255) NOT NULL,
  sender    VARCHAR(255) NOT NULL,
  recipient VARCHAR(255) NOT NULL,
  count     INTEGER      NOT NULL,
  instance  VARCHAR(255) NOT NULL,
  ts_entry  DATETIME     NOT NULL,
  queue_id  VARCHAR(255) NOT NULL,
  size      INTEGER      NOT NULL
);

CREATE INDEX graylist_ts_ok_idx ON graylist (ts_ok);
CREATE INDEX graylist_ts_entry_idx ON graylist (ts_entry);
--CREATE INDEX graylist_halfopen_idx ON graylist ((ts_latest-ts_entry));
