#!/usr/bin/perl -w

use strict;
use warnings;
use DBI;

our $CONFIG_FILE		= "/usr/local/etc/graypol.conf";
my %DEFAULTS;
$DEFAULTS{dbtype}		= "Pg";
$DEFAULTS{dbhost}		= "";
$DEFAULTS{dbport}		= "";
$DEFAULTS{dbuser}		= "";
$DEFAULTS{dbpass}		= "";
$DEFAULTS{dbname}		= "";
$DEFAULTS{db_key_err}		= "duplicate key violates unique constraint";
$DEFAULTS{listen_graypol}	= "/var/run/graypold_graypol.sock";
$DEFAULTS{listen_mailcount}	= "/var/run/graypold_mailcount.sock";
$DEFAULTS{listen_sent}		= "/var/run/graypold_sent.sock";
$DEFAULTS{owner}		= "postfix";
$DEFAULTS{rights}		= "0600";
$DEFAULTS{backlog}		= "128";
$DEFAULTS{pidfile}		= "/var/run/graypold.pid";
$DEFAULTS{user}			= "nobody";

$DEFAULTS{lockfile}		= "/var/lock/graycron.lock";
$DEFAULTS{rrdfile}		= "/var/db/graylist.rrd";
$DEFAULTS{rrdfile2}		= "/var/db/mailcount.rrd";
$DEFAULTS{picpath}		= "/usr/local/www/data";
$DEFAULTS{delay_permit}		= "interval '3 minutes'";
$DEFAULTS{delay_halfopen}	= "interval '12 hours'";
$DEFAULTS{delay_max}		= "interval '35 days'";

our %config = %DEFAULTS;

sub dbopen ($)
{
  my %attr = ( RaiseError => 1, PrintError => 0, HandleError => $_[0] ) if $_[0];
  my $dsn = "DBI:$config{dbtype}:dbname=$config{dbname}";
  $dsn .= ";host=$config{dbhost}" if $config{dbhost};
  $dsn .= ";port=$config{dbport}" if $config{dbport};
  return DBI->connect($dsn, $config{dbuser}, $config{dbpass}, \%attr);
}

sub load_config ()
{
  open(FH, $CONFIG_FILE) || return "$CONFIG_FILE: $!";
  foreach (map { s/\r|\n//sgio; $_ } <FH>) {
    next if /^$/;
    next if /^#/;
    next if /^;/;
    next if /^\/\//;
    next unless /^([^\s]+)\s+=\s+(.+)$/;
    my $key = $1;
    my $value = $2;
    $config{$key} = $value if exists $DEFAULTS{$key};
  }
  close(FH);
  return "";
}

1;
