#!/usr/bin/perl

use DBI;
use RRDs;
require "/usr/local/lib/graylib.pl";

# called every minute
$actions{permit} = sub {
  $sql = "UPDATE $config{db_tbl_gray} SET $config{db_field_ok} = '1', ";
  $sql .= "$config{db_field_ts_ok} = now() WHERE ";
  $sql .= "$config{db_field_ok} = '0' AND ";
  $sql .= "now() - $config{delay_permit} >= $config{db_field_ts_entry}";
  $dbh->do($sql);
};

# called every 5 minutes
$actions{graph} = sub {
  if (!-e $config{rrdfile}) {
    # hmmm, step implies crontab entry here...
    RRDs::create($config{rrdfile}, "--start", "1000000000", "--step", 300,
                 "DS:deny:GAUGE:600:U:U", "DS:halfopen:GAUGE:600:0:U",
                 "DS:permit:GAUGE:600:U:U", "RRA:MAX:0:1:210240");
    $err = RRDs::error;
    die "create $config{rrdfile} failed: $err" if $err;
  }
  # get numbers
  $cnt_deny = &dbcount("'0'");
  $cnt_halfopen = &dbcount("'1' AND " .
    "$config{db_field_ts_entry} = $config{db_field_ts_latest}");
  $cnt_permit = &dbcount("'1' AND " .
    "$config{db_field_ts_entry} != $config{db_field_ts_latest}");
  # update rrd file
  RRDs::update($config{rrdfile}, "-t", "deny:halfopen:permit",
               "N:$cnt_deny:$cnt_halfopen:$cnt_permit");
  $err = RRDs::error;
  die "update $config{rrdfile} failed: $err" if $err;
  # make pictures
  $jetzt = localtime(time());
  $jetzt =~ s/\:/\\\:/sgio;
  foreach ("1h", "1d", "1w", "1m", "1y") {
    $fn = "$config{picpath}/graylist$_.png";
    RRDs::graph($fn, "-s", "end-$_", "-l", "0",
                "DEF:deny=$config{rrdfile}:deny:MAX",
                "DEF:halfopen=$config{rrdfile}:halfopen:MAX",
                "DEF:permit=$config{rrdfile}:permit:MAX",
                "COMMENT:[$jetzt]\\r",
                "AREA:permit#00FF00:permit\\: $cnt_permit\\n",
                "STACK:halfopen#0000FF:half open\\: $cnt_halfopen\\n",
                "STACK:deny#FF0000:deny\\: $cnt_deny");
    $err = RRDs::error;
    die "graph $fn ($config{rrdfile}) failed: $err" if $err;
  }
};

# called once an hour
$actions{clean} = sub {
  $sql = "DELETE FROM $config{db_tbl_gray} WHERE $config{db_field_ok} = '1' ";
  $sql .= "AND $config{db_field_ts_entry} = $config{db_field_ts_latest} AND ";
  $sql .= "now() - $config{delay_halfopen} >= $config{db_field_ts_entry}";
  $dbh->do($sql);
};

# called once a day
$actions{scrub} = sub {
  $sql = "DELETE FROM $config{db_tbl_gray} WHERE $config{db_field_ok} = '1' ";
  $sql .= "AND now() - $config{delay_max} >= $config{db_field_ts_latest}";
  $dbh->do($sql);
};

# get action from commandline
$action = shift;
die "usage: $0 <permit | graph | clean | scrub>" if !exists $actions{$action};

# load config
$err = &load_config();
warn $err if $err;

# avoid multiple instances
$lockfile = "$config{lockfile}.$action";
open(FH, ">$lockfile") or die "$lockfile: $!";
flock FH, 6 or exit 0;

# open database and do something
$dbh = &dbopen(undef);
&{$actions{$action}}();
$dbh->disconnect();

# byebye
flock FH, 8 or die "$lockfile: $!";
close(FH);
unlink $lockfile;

sub dbcount ()
{
  $sql = "SELECT COUNT(*) AS cnt FROM $config{db_tbl_gray} ";
  $sql .= "WHERE $config{db_field_ok} = $_[0]";
  $sth = $dbh->prepare($sql);
  $sth->execute();
  $row = $sth->fetchrow_hashref();
  $sth = undef;
  return $row->{cnt};
}
