/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Formatter;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class lechunk
implements ActionListener,
Runnable,
ListSelectionListener,
FilenameFilter {
    static final int CHUNK_SIZE = 0x20000000;
    static final File REPOSITORY_DIR = new File(".lechunk");
    JFrame mainFrame;
    JProgressBar progressBar;
    JButton cancelButton;
    JButton exportButton;
    JButton deleteButton;
    JList taskList;
    JList repositoryList;
    JPasswordField pwdField;
    DefaultListModel taskListModel;
    DefaultListModel repositoryListModel;
    Thread worker;
    long currentSize;
    long bytesSoFar;
    long startTime;
    JFileChooser importChooser;
    JFileChooser exportChooser;
    boolean brokenJFileChooser = System.getProperty("os.name").equals("Mac OS X");

    lechunk() {
        JComponent jComponent;
        Object object;
        JPanel jPanel;
        this.exportChooser = new JFileChooser();
        if (this.brokenJFileChooser) {
            jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            object = new String[]{"You are running a", "broken operating system.", "Do not select the", "destination directory.", "Change into it!"};
            for (int i = 0; i < ((String[])object).length; ++i) {
                jComponent = new JLabel((String)object[i]);
                jComponent.setAlignmentX(0.5f);
                jPanel.add(jComponent);
            }
            this.exportChooser.setAccessory(jPanel);
        }
        this.exportChooser.setMultiSelectionEnabled(false);
        this.exportChooser.setFileSelectionMode(1);
        this.importChooser = new JFileChooser();
        this.importChooser.setMultiSelectionEnabled(true);
        this.importChooser.setFileSelectionMode(0);
        jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 2));
        object = new JButton("Import");
        ((AbstractButton)object).setActionCommand("Import");
        ((AbstractButton)object).addActionListener(this);
        ((JComponent)object).setAlignmentY(0.5f);
        ((JComponent)object).setAlignmentX(0.5f);
        jPanel.add((Component)object);
        this.exportButton = new JButton("Export");
        this.exportButton.setActionCommand("Export");
        this.exportButton.addActionListener(this);
        this.exportButton.setAlignmentY(0.5f);
        this.exportButton.setAlignmentX(0.5f);
        this.exportButton.setEnabled(false);
        jPanel.add(this.exportButton);
        this.deleteButton = new JButton("Delete");
        this.deleteButton.setActionCommand("Delete");
        this.deleteButton.addActionListener(this);
        this.deleteButton.setAlignmentY(0.5f);
        this.deleteButton.setAlignmentX(0.5f);
        this.deleteButton.setEnabled(false);
        jPanel.add(this.deleteButton);
        jPanel.setAlignmentY(0.5f);
        jPanel.setAlignmentX(0.5f);
        this.repositoryListModel = new DefaultListModel();
        this.repositoryList = new JList(this.repositoryListModel);
        this.repositoryList.setLayoutOrientation(1);
        this.repositoryList.addListSelectionListener(this);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 3));
        jPanel2.setBorder(new TitledBorder("Repository"));
        jPanel2.add(new JScrollPane(this.repositoryList));
        jPanel2.add(Box.createVerticalStrut(10));
        jPanel2.add(jPanel);
        jPanel2.add(Box.createVerticalStrut(10));
        this.progressBar = new JProgressBar(0, 0);
        this.progressBar.setValue(0);
        this.progressBar.setStringPainted(false);
        this.progressBar.setAlignmentY(0.5f);
        this.progressBar.setAlignmentX(0.5f);
        jPanel2.add(this.progressBar);
        jPanel2.setAlignmentY(0.5f);
        jPanel2.setAlignmentX(0.5f);
        jComponent = new JPanel();
        jComponent.setLayout(new BoxLayout(jComponent, 3));
        jComponent.setBorder(new TitledBorder("Password"));
        this.pwdField = new JPasswordField(1);
        this.pwdField.setAlignmentY(0.5f);
        this.pwdField.setAlignmentX(0.5f);
        this.pwdField.setMinimumSize(new Dimension(50, 20));
        this.pwdField.setMaximumSize(new Dimension(500, 20));
        this.pwdField.setPreferredSize(new Dimension(100, 20));
        jComponent.add(this.pwdField);
        jComponent.setAlignmentY(0.5f);
        jComponent.setAlignmentX(0.5f);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 3));
        jPanel3.add(jPanel2);
        jPanel3.add(Box.createVerticalStrut(15));
        jPanel3.add(jComponent);
        jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 2));
        jPanel.add(jPanel3);
        this.taskListModel = new DefaultListModel();
        this.taskList = new JList(this.taskListModel);
        this.taskList.addListSelectionListener(this);
        jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 3));
        jPanel2.setBorder(new TitledBorder("Tasks"));
        jPanel2.add(new JScrollPane(this.taskList));
        jPanel2.add(Box.createVerticalStrut(10));
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setActionCommand("Cancel");
        this.cancelButton.addActionListener(this);
        this.cancelButton.setAlignmentY(0.5f);
        this.cancelButton.setAlignmentX(0.5f);
        this.cancelButton.setEnabled(false);
        jPanel2.add(this.cancelButton);
        jPanel2.setAlignmentY(0.5f);
        jPanel2.setAlignmentX(0.5f);
        jPanel.add(jPanel2);
        this.mainFrame = new JFrame("leChunk"){

            @Override
            protected void processWindowEvent(WindowEvent windowEvent) {
                super.processWindowEvent(windowEvent);
                if (windowEvent.getID() == 201) {
                    System.exit(0);
                }
            }
        };
        this.mainFrame.setIconImage(new ImageIcon(lechunk.class.getResource("logo.png")).getImage());
        this.mainFrame.getContentPane().add(jPanel);
        this.mainFrame.pack();
        this.mainFrame.setVisible(true);
        this.mainFrame.setEnabled(true);
        this.worker = null;
        this.updateRepositoryList();
    }

    void wrkDirCleanup(File file) {
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            fileArray[i].delete();
        }
    }

    void wrkDirRemove(File file) {
        this.wrkDirCleanup(file);
        file.delete();
        new File(file.getAbsolutePath() + ".md5").delete();
        new File(file.getAbsolutePath() + ".size").delete();
        REPOSITORY_DIR.delete();
    }

    boolean importChunk(FileInputStream fileInputStream, OutputStream outputStream, String string) throws IOException {
        int n;
        byte[] byArray = new byte[65536];
        for (long i = 0L; i < 0x20000000L; i += (long)n) {
            n = fileInputStream.read(byArray);
            if (n == -1) {
                return false;
            }
            outputStream.write(byArray, 0, n);
            this.bytesSoFar += (long)n;
            this.progressBar.setValue((int)(10000L * this.bytesSoFar / this.currentSize));
            this.progressBar.setString("Importing " + string + ": " + (int)(100L * this.bytesSoFar / this.currentSize) + "%");
            long l = Calendar.getInstance().getTimeInMillis() / 1000L;
            if (l <= this.startTime) continue;
            long l2 = this.bytesSoFar / 1024L / (l - this.startTime);
            this.progressBar.setToolTipText(new Long(l2).toString() + " kB/s");
        }
        return true;
    }

    boolean importOverwrite(String string) {
        return JOptionPane.showOptionDialog(null, string + " already exists in " + "the repository. Overwrite?", string, 0, 3, null, null, null) == 0;
    }

    void importFile(Job job) {
        int n = 0;
        File file = job.getFile();
        String string = " " + file.getName();
        File file2 = new File(REPOSITORY_DIR, string);
        File file3 = new File(REPOSITORY_DIR, string + ".md5");
        if (file3.exists()) {
            if (this.importOverwrite(string)) {
                this.wrkDirRemove(file2);
            } else {
                return;
            }
        }
        file2.mkdirs();
        this.progressBar.setValue(0);
        this.progressBar.setStringPainted(true);
        try {
            OutputStream outputStream;
            boolean bl;
            FileInputStream fileInputStream = new FileInputStream(file);
            this.bytesSoFar = 0L;
            this.currentSize = file.length();
            this.startTime = Calendar.getInstance().getTimeInMillis() / 1000L;
            byte[] byArray = Job.AES_align(new Long(this.currentSize).toString()).getBytes("US-ASCII");
            this.progressBar.setMaximum(10000);
            do {
                outputStream = new FileOutputStream(new File(file2, new Formatter().format("%016d", n).toString()));
                if (job.hasPassword().booleanValue()) {
                    outputStream = new CipherOutputStream(outputStream, job.getCipher());
                }
                bl = this.importChunk(fileInputStream, outputStream, string);
                outputStream.close();
                ++n;
            } while (bl);
            fileInputStream.close();
            FileOutputStream fileOutputStream = new FileOutputStream(new File(REPOSITORY_DIR, string + ".md5"));
            fileOutputStream.write(byArray);
            fileOutputStream.close();
            outputStream = new FileOutputStream(new File(REPOSITORY_DIR, string + ".size"));
            if (job.hasPassword().booleanValue()) {
                outputStream = new CipherOutputStream(outputStream, job.getCipher());
            }
            outputStream.write(byArray);
            outputStream.close();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, exception.toString(), string, 0);
            this.wrkDirRemove(file2);
        }
        this.progressBar.setStringPainted(false);
        this.progressBar.setValue(0);
        this.progressBar.setMaximum(0);
    }

    void exportChunk(InputStream inputStream, FileOutputStream fileOutputStream, String string) throws Exception {
        int n;
        byte[] byArray = new byte[65536];
        long l = 0L;
        while ((n = inputStream.read(byArray)) != -1) {
            fileOutputStream.write(byArray, 0, n);
            l += (long)n;
            this.bytesSoFar += (long)n;
            this.progressBar.setValue((int)(10000L * this.bytesSoFar / this.currentSize));
            this.progressBar.setString("Exporting " + string + ": " + (int)(100L * this.bytesSoFar / this.currentSize) + "%");
            long l2 = Calendar.getInstance().getTimeInMillis() / 1000L;
            if (l2 <= this.startTime) continue;
            long l3 = this.bytesSoFar / 1024L / (l2 - this.startTime);
            this.progressBar.setToolTipText(new Long(l3).toString() + " kB/s");
        }
        inputStream.close();
    }

    boolean exportOverwrite(File file, String string) {
        return JOptionPane.showOptionDialog(null, string + " already exists in " + file.getAbsolutePath() + ". Overwrite?", string, 0, 3, null, null, null) == 0;
    }

    void exportFile(Job job) {
        String string;
        File file = job.getFile();
        File file2 = new File(file, (string = job.getName()).substring(1, string.length()));
        if (file2.exists() && !this.exportOverwrite(file, string)) {
            return;
        }
        try {
            File file3 = new File(REPOSITORY_DIR, string + ".md5");
            FileInputStream fileInputStream = new FileInputStream(file3);
            this.startTime = Calendar.getInstance().getTimeInMillis() / 1000L;
            byte[] byArray = new byte[fileInputStream.available()];
            byte[] byArray2 = new byte[fileInputStream.available()];
            fileInputStream.read(byArray);
            fileInputStream.close();
            InputStream inputStream = new FileInputStream(new File(REPOSITORY_DIR, string + ".size"));
            if (job.hasPassword().booleanValue()) {
                inputStream = new CipherInputStream(inputStream, job.getCipher());
            }
            ((InputStream)inputStream).read(byArray2);
            ((InputStream)inputStream).close();
            if (!new String(byArray2).equals(new String(byArray))) {
                JOptionPane.showMessageDialog(null, "Wrong password!", string, 0);
                return;
            }
            this.bytesSoFar = 0L;
            this.currentSize = new Long(new String(byArray2).trim());
            this.progressBar.setValue(0);
            this.progressBar.setStringPainted(true);
            this.progressBar.setMaximum(10000);
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            File[] fileArray = new File(REPOSITORY_DIR, string).listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                inputStream = new FileInputStream(fileArray[i]);
                if (job.hasPassword().booleanValue()) {
                    inputStream = new CipherInputStream(inputStream, job.getCipher());
                }
                this.exportChunk(inputStream, fileOutputStream, string);
            }
            fileOutputStream.close();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, exception.toString(), string, 0);
            file2.delete();
        }
        this.progressBar.setStringPainted(false);
        this.progressBar.setValue(0);
        this.progressBar.setMaximum(0);
    }

    @Override
    public void run() {
        Job job;
        while ((job = this.updateTaskList(TASKLIST_MODE.POP, null)) != null) {
            switch (job.getMode()) {
                case IMPORT: {
                    this.importFile(job);
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            lechunk.this.updateRepositoryList();
                        }
                    });
                    break;
                }
                case EXPORT: {
                    this.exportFile(job);
                }
            }
        }
    }

    synchronized Job updateTaskList(TASKLIST_MODE tASKLIST_MODE, Job job) {
        switch (tASKLIST_MODE) {
            case PUSH: {
                this.taskListModel.addElement(job);
                if (this.worker != null) break;
                this.worker = new Thread(this);
                this.worker.start();
                break;
            }
            case POP: {
                if (this.taskListModel.isEmpty()) {
                    this.worker = null;
                    break;
                }
                job = (Job)this.taskListModel.firstElement();
                try {
                    EventQueue.invokeAndWait(new SafeTaskListModelRemove(this.taskListModel, job));
                    break;
                }
                catch (Exception exception) {
                    System.out.println(exception.toString());
                }
            }
        }
        return job;
    }

    void actionImport() {
        if (this.importChooser.showOpenDialog(this.mainFrame) == 0) {
            File[] fileArray = this.importChooser.getSelectedFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                this.updateTaskList(TASKLIST_MODE.PUSH, new Job(Job.MODE.IMPORT, fileArray[i], null, new String(this.pwdField.getPassword())));
            }
        }
    }

    void actionExport() {
        if (this.exportChooser.showSaveDialog(this.mainFrame) == 0) {
            File file = this.brokenJFileChooser ? this.exportChooser.getCurrentDirectory() : this.exportChooser.getSelectedFile();
            String[] stringArray = this.getSelectedRepositoryFiles();
            for (int i = 0; i < stringArray.length; ++i) {
                this.updateTaskList(TASKLIST_MODE.PUSH, new Job(Job.MODE.EXPORT, file, stringArray[i], new String(this.pwdField.getPassword())));
            }
        }
    }

    String[] getSelectedRepositoryFiles() {
        int[] nArray = this.repositoryList.getSelectedIndices();
        String[] stringArray = new String[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            stringArray[i] = (String)this.repositoryListModel.get(nArray[i]);
        }
        return stringArray;
    }

    boolean deleteFromRepository(String[] stringArray) {
        String string = "";
        for (int i = 0; i < stringArray.length; ++i) {
            string = string + "\n" + stringArray[i];
        }
        String string2 = stringArray.length == 1 ? "Do you really want to delete this file from the repository?\n" : "Do you really want to delete these files from the repository?\n";
        return JOptionPane.showConfirmDialog(null, string2 + string, "Confirm deletion", 0) == 0;
    }

    void actionDelete() {
        String[] stringArray = this.getSelectedRepositoryFiles();
        if (this.deleteFromRepository(stringArray)) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.wrkDirRemove(new File(REPOSITORY_DIR, stringArray[i]));
            }
        }
        this.updateRepositoryList();
    }

    void actionCancel() {
        Object e;
        while ((e = this.taskList.getSelectedValue()) != null) {
            this.taskListModel.removeElement(e);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Import")) {
            this.actionImport();
        } else if (string.equals("Export")) {
            this.actionExport();
        } else if (string.equals("Delete")) {
            this.actionDelete();
        } else if (string.equals("Cancel")) {
            this.actionCancel();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getSource() == this.taskList) {
            if (this.taskList.getSelectedIndex() == -1) {
                this.cancelButton.setEnabled(false);
            } else {
                this.cancelButton.setEnabled(true);
            }
        }
        if (listSelectionEvent.getSource() == this.repositoryList) {
            if (this.repositoryList.getSelectedIndex() == -1) {
                this.exportButton.setEnabled(false);
                this.deleteButton.setEnabled(false);
            } else {
                this.exportButton.setEnabled(true);
                this.deleteButton.setEnabled(true);
            }
        }
    }

    void updateRepositoryList() {
        String[] stringArray = REPOSITORY_DIR.list(this);
        this.repositoryListModel.clear();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.repositoryListModel.addElement(stringArray[i]);
            }
        }
    }

    @Override
    public boolean accept(File file, String string) {
        File file2 = new File(file, string);
        File file3 = new File(file2, "0000000000000000");
        File file4 = new File(file, string + ".md5");
        File file5 = new File(file, string + ".size");
        return " ".equals(string.substring(0, 1)) && file2.isDirectory() && file3.isFile() && file4.isFile() && file5.isFile();
    }

    public static void main(String[] stringArray) {
        lechunk lechunk2 = new lechunk();
    }

    static enum TASKLIST_MODE {
        PUSH,
        POP;

    }
}

