/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

class Job {
    MODE mode;
    File file;
    String name;
    SecretKeySpec sks;
    boolean has_password;

    Job(MODE mODE, File file, String string, String string2) {
        this.mode = mODE;
        try {
            this.file = new File(file.getCanonicalPath());
        }
        catch (Exception exception) {
            this.file = file;
        }
        this.name = string;
        if (string2.length() > 0) {
            this.sks = new SecretKeySpec(Job.AES_align(string2).substring(0, 16).getBytes(), "AES");
            this.has_password = true;
        } else {
            this.has_password = false;
        }
    }

    static String AES_align(String string) {
        return string.concat("                ".substring(0, 16 - string.length() % 16));
    }

    MODE getMode() {
        return this.mode;
    }

    File getFile() {
        return this.file;
    }

    String getName() {
        return this.name;
    }

    Boolean hasPassword() {
        return this.has_password;
    }

    Cipher getCipher() throws Exception {
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(this.mode == MODE.IMPORT ? 1 : 2, this.sks);
        return cipher;
    }

    public String toString() {
        switch (this.mode) {
            case IMPORT: {
                return "Import " + this.file.getAbsolutePath();
            }
            case EXPORT: {
                return "Export " + this.name + " to " + this.file.getAbsolutePath();
            }
        }
        return "";
    }

    static enum MODE {
        IMPORT,
        EXPORT;

    }
}

