/*
 * $Header: /export/cvs/www.ogris.de/klogset/klogset.c,v 1.2 2002/11/10 22:55:45 fjo Exp $
 */

#include <linux/unistd.h>
#include <unistd.h>

/* LOG_BUF_LEN in printk.c on S390 */
#define MAX_LOG_BUF_LEN 131072

_syscall3(int,syslog,int,type,char *,bufp,int,len);

void usage ()
{
  write(1, "klogset - dumps kernel ring log buffer to stdout and \n" \
           "          sets level of kernel console logging\n" \
           "usage:    klogset <0-7>\n"\
           "examples: klogset 3\n" \
           "          klogset >/var/log/boot\n", 178);
  exit(-1);
}

void die ()
{
  write(2, "klogset: syslog() failed\n", 25);
  exit(-1);
}

int main (int argc, char *argv[])
{
  char c, buf[MAX_LOG_BUF_LEN];
  int i;

  switch (argc) {

    case 1:
      i = syslog(3, (char*) &buf, MAX_LOG_BUF_LEN);
      if (i == -1) die();
      write(1,buf,i);
      break;

    case 2:
      memcpy(&c,argv[1],1);
      if ((c < '0') || (c > '7')) usage();
      c -= '0';
      if (syslog(8, "", c)) die();
      break;

    default:
      usage();

  }
  return(0);
}
