#!/bin/sh

MAXFETCH=""

GLOBTMPDIR=/tmp
BINDIR=/usr/news/bin
TMPDIR=/var/tmp/news
OUTDIR=var/spool/news/outgoing
LIBDIR=/var/lib/suck
CONFDIR=/etc/news
HISTORY=/var/lib/news/history

HOST=localhost
FILTER=$BINDIR/rpostfilter
TMP=$TMPDIR/$$.art

PATH=$PATH:$BINDIR

suckpost () {
  SERVER=$1
  USER=$2
  PASS=$3
  OUT=$OUTDIR/$SERVER
  OUTOLD=$OUT.old

  mv $OUT $OUTOLD
  ctlinnd flush $SERVER

  if [ "$PASS" != "" ]; then 
    export NNTP_PASS=$PASS
    export NNTP_USER=$USER
  else
    unset NNTP_PASS
    unset NNTP_USER
  fi

  rpost $SERVER -b $OUTOLD -d -n -Q -f $FILTER \$\$o=$TMP $BINDIR/sm \$\$i $TMP
  rm -f $TMP

  CMD="suck $SERVER -A -a -B -bP 100 -c -dd $LIBDIR -dm $GLOBTMPDIR "
  CMD="$CMD -dt $TMPDIR -F -f -HF $HISTORY -hl $HOST "
  if [ "$MAXFETCH" != "" ]; then
    CMD="$CMD -i -$MAXFETCH "
  fi
  CMD="$CMD -M -m -n -p .$SERVER -Q -q"

  $CMD
}

echo "You did not modify suckpost.sh to fit your site."
exit 1
suckpost "news.provider.com" "username" "passwort"
