#!/bin/sh

if [ "$#" = "0" ]; then
  echo "Nothing to do"
  exit 1
fi

. /usr/news/lib/innshellvars

RECIPS=""
SUBJECT=""
TMPFILE="$PATHTMP/innmail$$"

while [ "$1" != "" ]; do
  case "$1" in
    "-s")
      shift
      SUBJECT="$1"
      ;;
    *)
      RECIPS="$RECIPS $1"
      ;;
  esac
  shift
done

if [ "$SUBJECT" = "" ]; then
  echo "No subject given"
  exit 1
fi

if [ "$RECIPS" = "" ]; then
  echo "No recipients given"
  exit 1
fi

echo "To:$RECIPS" >$TMPFILE
echo "Subject: $SUBJECT" >>$TMPFILE
echo "" >>$TMPFILE
while read LINE; do
  echo "$LINE" >>$TMPFILE
done
$MTA <$TMPFILE
rm -f $TMPFILE
