#ifndef _FW_H
#define _FW_H

#include <stdint.h>

struct rule {
  enum { NONE, ADD } action;
  int is_ipv6;
  void *src_ip;
  void *dst_ip;
  uint16_t src_port_low;
  uint16_t src_port_high;
  uint16_t dst_port_low;
  uint16_t dst_port_high;
  char *pf_queue;
  char *pf_anchor;
  unsigned long ipfw_call;
};

const char *fw_ident ();
void *fw_init ();
int fw_close (void *data);
int fw_add_rule (void *data, uint32_t rulenum, struct rule *rule);
int fw_del_rule (void *data, uint32_t rulenum);

#endif
