#include <stdlib.h>
#include <unistd.h>
#include <err.h>
#include "fw.h"

int main()
{
  void *fw_data;
  uint8_t testip1[4] = { 192, 168, 0, 10 };
  uint8_t testip2[4] = { 192, 168, 0, 15 };
  struct rule rule = {
    ADD,
    0,
    testip1,
    testip2,
    0,
    65535,
    22,
    22,
    NULL
  };

  fw_data = fw_init();
  if (fw_data == NULL)
    err(-1, "fw_init");

  if (fw_add_rule(fw_data, 1111, &rule))
    err(-1, "fw_add_rule");

  sleep(5);
  if (fw_del_rule(fw_data, 1111))
    err(-1, "fw_del_rule");

  if (fw_close(fw_data))
    err(-1, "fw_close");

  return 0;
}
