#ifndef _FILO_H
#define _FILO_H

#define INIT 0x07C0                 // where mbr is loaded
#define LOADSEG 0x1000              // where the protected mode code get loaded
#define INITSEG 0x9000              // where the bootsector get loaded
#define SETUPSEG 0x9020             // where setup get loaded
#define SETUPSECTS 0x01F1           // offset from INITSEG
#define BOOTLOADER 0x0210           // offset from INITSEG
#define CMDLINE 0x0228              // offset from INITSEG
#define CMDLINE_OFFS 0x9000         // where we load the commandline, offset from INITSEG
#define ROOTDEV 0x01FC              // offset from INITSEG
#define VIDMODE 0x01FA              // offset from INITSEG
#define CMDLINE_ADDR 0x99000        // flat address of commandline
#define STACKSEG 0x0100
#define STACKLEN 0x06C0

#define SECTOR_SIZE 0x0200
#define MBR_SIZE 0x01BE
#define INT_SIZE 4

#define HDIO_GETGEO 0x0301
#define GET_BLK 1
#define GET_BLKSIZE 2
#define PATH_DEV "/dev"
#define STDIN 0
#define STDOUT 1
#define STDERR 2
#define CMDL_SIZE 255
#define AUTO_SIZE 5
#define BUFFER_SIZE 4096
#define BOOT_MAGIC 0xAA55
#define FDGETPRM ( (2U<<30) | (2<<8) | 4 | (sizeof(struct floppy_struct)<<16) )

#endif
