#include "filo.h"

	.code16

	.text

	.global _start

_start:
	cli
	movw	$INIT,%ax
	movw	%ax,%ds
	movw	$STACKSEG,%ax
	movw	%ax,%ss
	movw	$STACKLEN,%sp
	sti

	movw	$INITSEG,%ax
	movw	%ax,%es
	movw	$2,%ax
	xorw	%bx,%bx
	movw	$load_area,%si
	call	inner_read_loop

	movb	%es:(SETUPSECTS),%al
	cmpb	$0,%al
	jne	no_historic_setupsects
	movb	$4,%al
no_historic_setupsects:
	decb	%al		// one sector of setup has already been read
	call	read_loop

load_kernel:
	movw	$LOADSEG,%ax
	movw	%ax,%es
	xorw	%ax,%ax
	xorw	%bx,%bx
	call	read_loop

	pushw	%cx

	pushw	%ds
	popw	%es
	movw	$gdt,%si
	movw	$0x8000,%cx
	movb	$0x87,%ah
	int	$0x15
	jc	int15_error

	movb	gdt_dst_addr+2,%al
	incb	%al
	movb	%al,gdt_dst_addr+2

	popw	%cx
	cmpw	$0,%cx
	jne	load_kernel

	movw	$INITSEG,%ax
	movw	%ax,%es
load_cmdline:
	xorw	%ax,%ax
	movw	$CMDLINE_OFFS,%bx
	call	read_loop
	cmpw	$0,%cx
	jne	load_cmdline

boot_kernel:
	call	get_cursor
	movw	$int15_error_msg,%bp
	movw	$2,%cx
	call	print		// print \r\n

	xorw	%ax,%ax		// reset discs
	xorw	%dx,%dx
	int	$0x13

	cli
	movw	$INITSEG,%ax
	movw	%ax,%ds
	movw	%ax,%es
	movw	%ax,%fs
	movw	%ax,%gs
	movw	%ax,%ss
	movw	%ax,%sp
	movb	$0xFF,%ss:(BOOTLOADER)
	movw	$0x0302,%ss:(ROOTDEV)
	movw	$0xfffe,%ss:(VIDMODE)
	movl	$CMDLINE_ADDR,%ss:(CMDLINE)
	ljmp	$SETUPSEG,$0

reload_bmap:
	pushw	%bx
	pushw	%es
	pushw	%ds
	popw	%es
	movw	$load_area,%bx
	call	read_sector
	xorw	%bx,%bx
	movw	%bx,read_state
	popw	%es
	popw	%bx
read_loop:
	movw	$load_area,%si
	addw	read_state,%si
inner_read_loop:
	movw	(%si),%cx
	addw	$2,%si
	movw	(%si),%dx
	addw	$2,%si
	addw	$INT_SIZE,read_state
	cmpw	$SECTOR_SIZE,read_state
	je	reload_bmap
	cmpw	$0,%cx
	jne	read_on
	cmpw	$0,%dx
	je	end_read_loop
read_on:
	call	read_sector
	addw	$SECTOR_SIZE,%bx
	cmpw	$0,%bx
	je	end_read_loop
	decw	%ax
	cmpw	$0,%ax
	jne	inner_read_loop
end_read_loop:
	ret

// read sector specified by %cx & %dx to %es:%bx
read_sector:
	pushw	%ax
	pushw	%bx
	pushw	%cx
	pushw	%dx
	pushw	%es
	pushw	%bp

	xorb	%ch,%ch
	movb	spin_state,%cl
	movw	$spin_symbols,%bp
	addw	%cx,%bp
	incb	%cl
	cmpb	$4,%cl
	jne	spin_CXok
	xorb	%cl,%cl
spin_CXok:
	movb	%cl,spin_state
	call	get_cursor
	xorb	%dl,%dl
	movw	$1,%cx
	call	print

	popw	%bp
	popw	%es
	popw	%dx
	popw	%cx
	popw	%bx

	movw	$0x0201,%ax
	int	$0x13
	jc	disc_error
	popw	%ax
	ret

// print string at %ds:%bp
print:
	pushw	%ds
	popw	%es
	movw	$7,%bx
	movw	$0x1301,%ax
	int	$0x10
	ret

// get cursor position in %dx, saves %cx
get_cursor:
	pushw	%cx
	xorb	%bh,%bh
	movb	$0x03,%ah
	int	$0x10
	popw	%cx
	ret

// fatal errors
disc_error:
	call	get_cursor
	movw	$disc_error_msg,%bp
	movw	disc_error_msg_len,%cx
	call	print
oops:
	jmp	oops

int15_error:
	call	get_cursor
	movw	$int15_error_msg,%bp
	movw	int15_error_msg_len,%cx
	call	print
	jmp	oops

disc_error_msg:
	.byte	10, 13
	.ascii	"i/o error"

disc_error_msg_len:
	.word	. - disc_error_msg

int15_error_msg:
	.byte	10, 13
	.ascii	"memory error"

int15_error_msg_len:
	.word	. - int15_error_msg

read_state:
	.word	SECTOR_SIZE-INT_SIZE

spin_state:
	.byte	0

spin_symbols:
	.ascii "|/-\\"

gdt:
	.word	0, 0, 0, 0, 0, 0, 0, 0
	.word	0xFFFF
gdt_src_addr:
	.byte	0, 0, 1   // =LOADSEG
	.byte	0x93
	.word	0
	.word	0xFFFF
gdt_dst_addr:
	.byte	0, 0, 0x10
	.byte	0x93
	.word	0
	.word	0, 0, 0, 0, 0, 0, 0, 0

	.org	MBR_SIZE-INT_SIZE

load_area:
