--
-- DTSVirtualHost.pgsql.sql - adds virtual host capabilities to a PostgreSQL based OTRS
-- Copyright (C) 2007, DTS Service GmbH, http://www.dts.de/
--

-- create virtual host table
CREATE TABLE dts_virtual_host (
    id           SERIAL       NOT NULL UNIQUE PRIMARY KEY,
    name         VARCHAR(100) NOT NULL UNIQUE,
    https        BOOLEAN      NOT NULL,
    ip           INET         UNIQUE,
    agent_url    VARCHAR(100) NOT NULL,
    customer_url VARCHAR(100) NOT NULL,
    public_url   VARCHAR(100) NOT NULL,
    soap_url     VARCHAR(100) NOT NULL,
    theme        INTEGER      NOT NULL REFERENCES theme,
    valid_id     INTEGER      NOT NULL REFERENCES valid,
    create_time  TIMESTAMP WITHOUT TIME ZONE NOT NULL,
    create_by    INTEGER      NOT NULL REFERENCES system_user,
    change_time  TIMESTAMP WITHOUT TIME ZONE NOT NULL,
    change_by    INTEGER      NOT NULL REFERENCES system_user,
    CHECK (NOT agent_url = customer_url),
    CHECK (NOT agent_url = public_url),
    CHECK (NOT agent_url = soap_url)
);
