#!/usr/bin/perl

package Kernel::System::Web::InterfaceSoapUser;

use strict;
use warnings;
use Kernel::Config;
use Kernel::System::Log;
use Kernel::System::Main;
use Kernel::System::DB;
use Kernel::System::Encode;
use Kernel::System::Web::Request;
use Kernel::DTSSoap;
use Kernel::System::DTSSoapUser;
use SOAP::Transport::HTTP;

our $VERSION = "1.0";

sub new
{
    my $Type = shift;
    my %Param = @_;

    my $Self = {};
    bless($Self, $Type);

    $Self->{ConfigObject} = Kernel::Config->new();
    $Self->{LogObject} = Kernel::System::Log->new(%$Self);
    $Self->{EncodeObject} = Kernel::System::Encode->new(%$Self);
    $Self->{MainObject} = Kernel::System::Main->new(%$Self);
    $Self->{DBObject} = Kernel::System::DB->new(%$Self);
    $Self->{SoapObject} = Kernel::DTSSoap->new(%$Self);
    $Self->{SoapUserObject} = Kernel::System::DTSSoapUser->new(%$Self);

    my $SoapCGIObject = SOAP::Transport::HTTP::CGI->new();
    $SoapCGIObject->serializer->use_prefix(1);
    $SoapCGIObject->dispatch_to("Kernel::DTSSoap");
    $Self->{SoapCGIObject} = $SoapCGIObject;

    return $Self;
}

sub Run ()
{
    my $Self = shift;
    my $RequestMethod = $ENV{REQUEST_METHOD};

    if ($RequestMethod eq "GET") {
        my $ParamObject = Kernel::System::Web::Request->new(%$Self);
        my $Status = "200";
        my $StatusText = "";
        my $ContentType = "text/plain";

        my %Param = ();
        foreach (qw(Action User Pass DebtorID DebtorName DebtorComment
            DebtorStreet DebtorZIP DebtorCity DebtorCountry DebtorURL
            ProjectName ProjectDebtorID
            ContactLogin ContactPass ContactSalutation
            ContactFirstname ContactSurname ContactEmail ContactDebtorID
            ContactPhone ContactFax ContactComment)) {
            $Param{$_} = $ParamObject->GetParam(Param => $_) || "";
        }

        eval {
            $StatusText = $Self->DispatchAction(%Param);
        };
        if ($@) {
            $Status = "400";
            $StatusText = $@;
        }
        elsif ($Param{Action} eq "WSDL") {
            $ContentType = "text/xml";
        }

        print "Status: ".$Status."\n".
            "Content-Type: ".$ContentType."\n".
            "Content-Length: ".length($StatusText)."\n\n".
            $StatusText;
    }
    else {
        $Self->{SoapCGIObject}->handle(@_);
    }
}

sub DispatchAction ()
{
    my $Self = shift;
    my %P = @_;
    my $SoapObject = $Self->{SoapObject};

    if ($P{Action} eq "CreateDebtor") {
        return $SoapObject->CreateDebtor(
            $P{User}, $P{Pass}, $P{DebtorID}, $P{DebtorName}, $P{DebtorComment},
            $P{DebtorStreet}, $P{DebtorZIP}, $P{DebtorCity}, $P{DebtorCountry},
            $P{DebtorURL})
        );
    }
    if ($P{Action} eq "CreateProject") {
        return $SoapObject->CreateProject(
            $P{User}, $P{Pass}, $P{ProjectName}, $P{ProjectDebtorID}
        );
    }
    if ($P{Action} eq "CreateContact") {
        return $SoapObject->CreateContact(
            $P{User}, $P{Pass}, $P{ContactLogin}, $P{ContactPass}, $P{ContactSalutation},
            $P{ContactFirstname}, $P{ContactSurname}, $P{ContactEmail}, $P{ContactDebtorID},
            $P{ContactPhone}, $P{ContactFax}, $P{ContactComment}
        );
    }
    if ($P{Action} eq "WSDL") {
        return $SoapObject->WSDL($P{User}, $P{Pass});
    }

    $SoapObject->Die("Unknown action in request: ".$P{Action});
}

1;
