package Kernel::System::DTSWsdl;

use strict;
use warnings;
use SOAP::Lite;
use Pod::WSDL;

our $VERSION = "1.0";
our @ISA = (qw(SOAP::Schema));

sub new
{
    my $Type = shift;
    my $Self = $Type->SUPER::new();

    return $Self;
}

sub access ()
{
    my $Self = shift;
    return $Self->WSDL();
}

sub WSDL ()
{
    my $Self = shift;

    $Self->schema_url(($ENV{HTTPS} ? "https" : "http")."://".
                      $ENV{SERVER_NAME}.$ENV{SCRIPT_NAME});

    my $WsdlObject = Pod::WSDL->new(
        source => "Kernel::DTSSoap",
        location => $Self->schema_url(),
        withDocumentation => 1,
        use => $Pod::WSDL::LITERAL_USE,
        pretty => 1
    );

    return $WsdlObject->WSDL;
}

# return all soap functions
sub MethodList ()
{
    my $Self = shift;

    my $Services = $Self->parse()->load()->services;
    my @Methods = qw(WSDL);

    foreach my $Service(sort keys %$Services) {
        foreach my $Method(sort keys %{$Services->{$Service}}) {
            push @Methods, $Method;
        }
    }

    return @Methods;
}

1;
