CREATE TABLE dts_soap_user (
    username     VARCHAR(100) NOT NULL UNIQUE PRIMARY KEY,
    password     VARCHAR(100) NOT NULL,
    valid_id     INTEGER      NOT NULL REFERENCES valid,
    create_time  TIMESTAMP WITHOUT TIME ZONE NOT NULL,
    create_by    INTEGER      NOT NULL REFERENCES system_user,
    change_time  TIMESTAMP WITHOUT TIME ZONE NOT NULL,
    change_by    INTEGER      NOT NULL REFERENCES system_user
);

CREATE TABLE dts_soap_user_address (
    username VARCHAR(100) NOT NULL REFERENCES dts_soap_user,
    address  VARCHAR(39)  NOT NULL,
    netmask  SMALLINT     NOT NULL CHECK((netmask >= 0) AND (netmask <= 128)),
    UNIQUE (username, address)
);

CREATE TABLE dts_soap_user_method (
    username VARCHAR(100) NOT NULL REFERENCES dts_soap_user,
    method   VARCHAR(100) NOT NULL,
    UNIQUE (username, method)
);
