<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="text" encoding="ISO-8859-1" />
    <xsl:template match="/">
        <xsl:text>ServerRoot      /usr/local
LoadModule      alias_module libexec/apache22/mod_alias.so
LoadModule      perl_module  libexec/apache22/mod_perl.so
AcceptMutex     sysvsem
NameVirtualHost *
PerlOptions     +ParseHeaders
PerlOptions     +SetupEnv
</xsl:text>
        <xsl:for-each select="Instances/Instance">
            <xsl:if test="system_id = $ProcessSystemID">
                <!-- ServerAdmin $admin_email -->
                <xsl:text>ServerAdmin     </xsl:text>
                <xsl:value-of select="admin_email" />
                <xsl:text>&#10;</xsl:text>
                <!-- PidFile $os_home/var/log/httpd.pid -->
                <xsl:text>PidFile         </xsl:text>
                <xsl:value-of select="os_home" />
                <xsl:text>/var/log/httpd.pid&#10;</xsl:text>
                <!-- Listen 127.0.0.1:$web_port -->
                <xsl:text>Listen          127.0.0.1:</xsl:text>
                <xsl:value-of select="web_port" />
                <xsl:text>&#10;</xsl:text>
                <!-- ErrorLog $os_home/var/log/httpd-error.log -->
                <xsl:text>ErrorLog        </xsl:text>
                <xsl:value-of select="os_home" />
                <xsl:text>/var/log/httpd-error.log&#10;</xsl:text>
                <!-- PerlRequire $os_home/bin/dtspreload.pl -->
                <xsl:text>PerlRequire     </xsl:text>
                <xsl:value-of select="os_home" />
                <xsl:text>/bin/dtspreload.pl&#10;</xsl:text>
                <xsl:for-each select="VirtualHosts/VirtualHost">
                    <!-- <VirtualHost *> -->
                    <xsl:text disable-output-escaping="yes">&#60;VirtualHost *>&#10;</xsl:text>
                    <!-- ServerName $name -->
                    <xsl:text>  ServerName        </xsl:text>
                    <xsl:value-of select="name" />
                    <xsl:text>&#10;</xsl:text>
                    <!-- DocumentRoot $os_home/var/httpd/htdocs -->
                    <xsl:text>  DocumentRoot      </xsl:text>
                    <xsl:value-of select="../../os_home" />
                    <xsl:text>/var/httpd/htdocs&#10;</xsl:text>
                    <!-- RedirectPermantent /favicon.ico /images/$theme_name/favicon.ico -->
                    <xsl:text>  RedirectPermanent /favicon.ico         /images/</xsl:text>
                    <xsl:value-of select="theme_name" />
                    <xsl:text>/favicon.ico&#10;</xsl:text>
                    <!-- RedirectPermanent /cgi-bin/index.pl /$agent_url -->
                    <xsl:text>  RedirectPermanent /cgi-bin/index.pl    /</xsl:text>
                    <xsl:value-of select="agent_url" />
                    <xsl:text>&#10;</xsl:text>
                    <!-- RedirectPermanent /cgi-bin/customer.pl /$customer_url -->
                    <xsl:text>  RedirectPermanent /cgi-bin/customer.pl /</xsl:text>
                    <xsl:value-of select="customer_url" />
                    <xsl:text>&#10;</xsl:text>
                    <!-- RedirectPermanent /cgi-bin/public.pl /$public_url -->
                    <xsl:text>  RedirectPermanent /cgi-bin/public.pl   /</xsl:text>
                    <xsl:value-of select="public_url" />
                    <xsl:text>&#10;</xsl:text>
                    <!-- <LocationMatch ^/$agent_url$> -->
                    <xsl:text disable-output-escaping="yes">  &#60;LocationMatch ^/</xsl:text>
                    <xsl:value-of select="agent_url" />
                    <xsl:text disable-output-escaping="yes">$>
    SetHandler          perl-script
    PerlSetVar          Module Agent
    PerlResponseHandler Kernel::System::Web::DTSWeb
  &#60;/LocationMatch>
</xsl:text>
                    <!-- <LocationMatch ^/$customer_url$> -->
                    <xsl:text disable-output-escaping="yes">  &#60;LocationMatch ^/</xsl:text>
                    <xsl:value-of select="customer_url" />
                    <xsl:text disable-output-escaping="yes">$>
    SetHandler          perl-script
    PerlSetVar          Module Customer
    PerlResponseHandler Kernel::System::Web::DTSWeb
  &#60;/LocationMatch>
</xsl:text>
                    <!-- <LocationMatch ^/$public_url$> -->
                    <xsl:text disable-output-escaping="yes">  &#60;LocationMatch ^/</xsl:text>
                    <xsl:value-of select="public_url" />
                    <xsl:text disable-output-escaping="yes">$>
    SetHandler          perl-script
    PerlSetVar          Module Public
    PerlResponseHandler Kernel::System::Web::DTSWeb
  &#60;/LocationMatch>
</xsl:text>
                    <!-- <LocationMatch ^/$soap_url$> -->
                    <xsl:text disable-output-escaping="yes">  &#60;LocationMatch ^/</xsl:text>
                    <xsl:value-of select="soap_url" />
                    <xsl:text disable-output-escaping="yes">$>
    SetHandler          perl-script
    PerlSetVar          Module SoapUser
    PerlResponseHandler Kernel::System::Web::DTSWeb
  &#60;/LocationMatch>
</xsl:text>
                    <!-- </VirtualHost> -->
                    <xsl:text disable-output-escaping="yes">&#60;/VirtualHost>&#10;</xsl:text>
                </xsl:for-each>
            </xsl:if>
        </xsl:for-each>
    </xsl:template>
</xsl:stylesheet>
