<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="text" encoding="ISO-8859-1" />
    <xsl:template match="/">
        <xsl:text disable-output-escaping="yes">ServerRoot        /usr/local
User              www
Group             www
AcceptMutex       sysvsem
LoadModule        log_config_module libexec/apache22/mod_log_config.so
LoadModule        proxy_module      libexec/apache22/mod_proxy.so
LoadModule        proxy_http_module libexec/apache22/mod_proxy_http.so
LoadModule        alias_module      libexec/apache22/mod_alias.so
LoadModule        ssl_module        libexec/apache22/mod_ssl.so
ServerAdmin       hostmaster@dts-online.net
PidFile           /var/run/httpd.pid
Listen            0.0.0.0:80
Listen            0.0.0.0:443
ErrorLog          /var/log/httpd-error.log
LogFormat         "%h %l %u %t \"%r\" %>s %b \"%{Referer}i\" \"%{User-Agent}i\"" combined
CustomLog         /var/log/httpd-access.log combined
ProxyPreserveHost On
NameVirtualHost   *:80
&#60;VirtualHost *:80>
    RedirectPermanent / http://www.dts.de/
    ServerName        www.dts.de
&#60;/VirtualHost>
</xsl:text>
        <xsl:for-each select="Instances/Instance/VirtualHosts/VirtualHost">
            <!-- <VirtualHost *:80> -->
            <xsl:text disable-output-escaping="yes">&#60;VirtualHost *:80>&#10;</xsl:text>
            <!-- ServerName $name -->
            <xsl:text>ServerName </xsl:text>
            <xsl:value-of select="name" />
            <xsl:text>&#10;</xsl:text>
            <xsl:if test="https = 1">
                <!-- RedirectPermanent / https://$name/ -->
                <xsl:text>RedirectPermanent / https://</xsl:text>
                <xsl:value-of select="name" />
                <xsl:text>/&#10;</xsl:text>
                <!-- </VirtualHost> -->
                <xsl:text disable-output-escaping="yes">&#60;/VirtualHost>&#10;</xsl:text>
                <!-- <VirtualHost $ip:443> -->
                <xsl:text disable-output-escaping="yes">&#60;VirtualHost </xsl:text>
                <xsl:value-of select="ip" />
                <xsl:text>:443>&#10;</xsl:text>
                <!-- ServerName $name -->
                <xsl:text>ServerName </xsl:text>
                <xsl:value-of select="name" />
                <xsl:text>&#10;</xsl:text>
                <!-- SSLEngine On -->
                <xsl:text>SSLEngine On&#10;</xsl:text>
                <!-- SSLCertificateFile -->
                <xsl:text>SSLCertificateFile /usr/local/etc/dtsmaster/otrs</xsl:text>
                <xsl:value-of select="../../system_id" />
                <xsl:text>.</xsl:text>
                <xsl:value-of select="name" />
                <xsl:text>.cert&#10;</xsl:text>
                <!-- SSLCertificateKeyFile -->
                <xsl:text>SSLCertificateKeyFile /usr/local/etc/dtsmaster/otrs</xsl:text>
                <xsl:value-of select="../../system_id" />
                <xsl:text>.</xsl:text>
                <xsl:value-of select="name" />
                <xsl:text>.key&#10;</xsl:text>
            </xsl:if>
            <!-- ProxyPass / http://127.0.0.1:$Instance::web_port/ -->
            <xsl:text>ProxyPass / http://127.0.0.1:</xsl:text>
            <xsl:value-of select="../../web_port" />
            <xsl:text>/&#10;</xsl:text>
            <!-- CustomLog $Instance::os_home/var/log/$name-access.log combined -->
            <xsl:text>CustomLog </xsl:text>
            <xsl:value-of select="../../os_home" />
            <xsl:text>/var/log/</xsl:text>
            <xsl:value-of select="name" />
            <xsl:text>-access.log combined&#10;</xsl:text>
            <!-- ServerAdmin $Instance::admin_email -->
            <xsl:text>ServerAdmin </xsl:text>
            <xsl:value-of select="../../admin_email" />
            <!-- </VirtualHost> -->
            <xsl:text disable-output-escaping="yes">&#10;&#60;/VirtualHost>&#10;</xsl:text>
        </xsl:for-each>
    </xsl:template>
</xsl:stylesheet>
