#!/usr/bin/perl

use strict;
use warnings;

my @PackageList = ();

foreach ("/usr/local/otrs", "/usr/local/otrs/Kernel/cpan-lib") {
    push @INC, $_;
    &FindPackages(
        StartPath => $_,
        PackageList => \@PackageList
    );
}

foreach (@PackageList) {
    my $Package = join("::", @$_);
    print "$Package\n";
    eval "use $Package;";
    die $@ if $@;
}

1;

sub FindPackages ()
{
    my %Param = @_;

    my $StartPath = $Param{StartPath} || "";
    my $RelativePath = $Param{RelativePath} || [];
    my $Level = $Param{Level} || 1;
    my $PackageList = $Param{PackageList} || [];
    
    if ($StartPath =~ /[^\/]$/) {
        $StartPath .= "/";
    }

    if (!opendir(DIR, $StartPath)) {
        return;
    }
    my @Files = readdir(DIR);
    closedir(DIR);

    foreach (sort @Files) {
        next if /LDAP/o;
        next if /Radius/o;
        my $FullPath = $StartPath.$_;
        if (-d $FullPath) {
            next if ($_ eq ".");
            next if ($_ eq "..");
            next if (($Level == 1) && ($_ ne "Kernel") && ($_ ne "HTML"));
            next if (($Level == 2) && ($_ eq "cpan-lib"));
            &FindPackages(
                StartPath => $FullPath,
                RelativePath => [ @$RelativePath, $_ ],
                Level => $Level + 1,
                PackageList => $PackageList
            );
        }
        if (-f $FullPath && s/\.pm$//o) {
            push @$PackageList, [ @$RelativePath, $_ ];
        }
    };
}
