--
-- DTSMaster.pgsql.sql - PostgreSQL based meta-database for multiple OTRS
--                       instances per machine
-- Copyright (C) 2007, DTS Service GmbH, http://www.dts.de/
--

CREATE TABLE dts_master (
    system_id      INTEGER       NOT NULL UNIQUE PRIMARY KEY,
    -- domain names limited due to RFC1024
    hostname       VARCHAR(255)  NOT NULL UNIQUE,
    -- limits from OTRS db structure
    admin_login    VARCHAR(200)  NOT NULL,
    admin_fname    VARCHAR(150)  NOT NULL,
    admin_lname    VARCHAR(150)  NOT NULL,
    admin_email    VARCHAR(250)  NOT NULL,
    admin_password VARCHAR(50)   NOT NULL,
    -- unix user/group names limited to 16 characters
    os_user        VARCHAR(16)   NOT NULL UNIQUE,
    os_uid         INTEGER       NOT NULL UNIQUE,
    os_group       VARCHAR(16)   NOT NULL UNIQUE,
    os_gid         INTEGER       NOT NULL UNIQUE,
    -- limit to reasonable value
    os_comment     VARCHAR(250)  NOT NULL,
    os_home        VARCHAR(4096) NOT NULL UNIQUE,
    web_user       VARCHAR(16)   NOT NULL UNIQUE,
    web_uid        INTEGER       NOT NULL UNIQUE,
    web_group      VARCHAR(16)   NOT NULL UNIQUE,
    web_gid        INTEGER       NOT NULL UNIQUE,
    web_port       INTEGER       NOT NULL UNIQUE,
    db_driver      VARCHAR(16)   NOT NULL,
    -- limited due to RFC1024
    db_host        VARCHAR(255)  NOT NULL,
    db_port        INTEGER       NOT NULL,
    db_name        TEXT          NOT NULL,
    db_user        TEXT          NOT NULL,
    db_password    TEXT          NOT NULL CHECK(char_length(db_password) > 5),
    enabled        BOOLEAN       NOT NULL DEFAULT true,
    create_time    TIMESTAMP WITHOUT TIME ZONE
                                 NOT NULL DEFAULT current_timestamp,
    UNIQUE (db_driver, db_host, db_port, db_name)
);
