# --
# Kernel/System/DTSLib.pm - collection of DTS specific functions
# Copyright (C) 2007, DTS Service GmbH, http://www.dts.de/
# --

package Kernel::System::DTSLib;

use strict;

our $VERSION = "1.0";

sub new ()
{
    my $Type = shift;
    my %Param = @_;
    my $Self = {};

    bless ($Self, $Type);

    # adopt all provided objects
    foreach (keys %Param) {
        $Self->{$_} = $Param{$_};
    }

    # check needed stuff
    foreach (qw(LogObject TimeObject ConfigObject)) {
        if (!$Self->{$_}) {
            die "Got no $_!";
        }
    }

    return $Self;
}

sub MakeDirectories ()
{
    my $Self = shift;
    my %Param = @_;

    foreach (@{$Param{Directories}}) {
        if (!-d $_) {
            if (!mkdir($_)) {
                $Self->{LogObject}->Log(
                    Priority => "Error",
                    Message => "can not create directory $_"
                );
                return;
            }
        }
    }

    return 1;
}

sub WriteVersionedFile ()
{
    my $Self = shift;
    my %Param = @_;
    my $LogObject = $Self->{LogObject};

    foreach (qw(FileName)) {
        if (!$Param{$_}) {
            $LogObject->Log(
                Priority => "Error",
                Message => "Got no $_!"
            );
            return;
        }
    }

    my $ArchiveExtension = ".".$Self->{TimeObject}->CurrentTimestamp().
        ".".$Self->{UserID}.".".$Self->{UserLogin};

    foreach ($ArchiveExtension, "") {
        if (!$Self->WriteFile(
            FileName => $Param{FileName}.$_,
            Data => $Param{Data}
        )) {
            return;
        }
    }

    return 1;

}

sub WriteFile ()
{
    my $Self = shift;
    my %Param = @_;
    my $LogObject = $Self->{LogObject};

    foreach (qw(FileName Data)) {
        if (!defined $Param{$_}) {
            $LogObject->Log(
                Priority => "Error",
                Message => "Got no $_!"
            );
            return;
        }
    }

    my $TempFile = $Param{FileName}.".tmp";
    my $Error = "";

    # write data to temp file
    if (!open(FH, ">$TempFile")) {
        $Error = "Can not open $TempFile for writing: $!";
    }
    if (!$Error && !flock(FH, 2)) {
        $Error = "Can not lock $TempFile exclusively: $!";
    }
    if (!$Error && !seek(FH, 0, 0)) {
        $Error = "Can not seek $TempFile to beginning of file: $!";
    }
    if (!$Error) {
        print FH ${$Param{Data}};
        close(FH);
        if (!rename($TempFile, $Param{FileName})) {
            $Error = "Can not rename $TempFile to $Param{FileName}: $!";
        }
    }
    if ($Error) {
        $LogObject->Log(
            Priority => "Error",
            Message => $Error
        );
        return;
    }

    return 1;
}

1;
