# --
# Kernel/System/Ticket/DTSFreetextAcl.pm - forces Acl per queue
# Copyright (C) 2007, DTS Service GmbH, http://www.dts.de/
# --

package Kernel::System::Ticket::DTSFreetextAcl;

use strict;
use Kernel::System::Valid;
use Kernel::System::DTSFreetext;

our $VERSION = "1.0";

sub new ()
{
    my $Type = shift;
    my %Param = @_;
    my $Self = {};

    bless ($Self, $Type);

    # adopt all provided objects
    foreach (keys %Param) {
        $Self->{$_} = $Param{$_};
    }

    # check needed stuff
    foreach (qw(TicketObject DBObject)) {
        if (!$Self->{$_}) {
            die "Got no $_!";
        }
    }

    # create needed objects
    $Self->{ValidObject} = Kernel::System::Valid->new(%Param);
    $Self->{FreetextObject} = Kernel::System::DTSFreetext->new(%Param);

    return $Self;
}

sub Run ()
{
    my $Self = shift;
    my %Param = @_;
    my $Acl = $Param{Acl} || {};
    my $QueueID = $Param{QueueID} || undef;
    my $TicketID = $Param{TicketID} || undef;
    my $FreetextObject = $Self->{FreetextObject};

    if (!defined $QueueID && defined $TicketID) {
        my %Ticket = $Self->{TicketObject}->TicketGet(
            TicketID => $TicketID,
            UserID => $Self->{UserID},
        );
        if (defined $Ticket{QueueID}) {;
            $QueueID = $Ticket{QueueID};
        }
    }

    my %NewAcl = ();

    if (defined $QueueID) {
        my @List = $FreetextObject->FreetextList(
            QueueID => $QueueID,
            Valid => 1
        );

        foreach (@List) {
            push @{$NewAcl{$_->{Object}}}, $_->{Name};
        }
    }

    my %Objects = $FreetextObject->FreetextObjects();
    foreach (keys %Objects) {
        if (!defined $NewAcl{$_}) {
            push @{$NewAcl{$_}}, $_." (not used)";
        }
    }

    $Acl->{"ACL-DTSFreetext"}->{"Possible"}->{"Ticket"} = \%NewAcl;
}

1;
