# --
# Kernel/System/DTSFreetext.pm - collection of DTSFreetext specific functions
# Copyright (C) 2007, DTS Service GmbH, http://www.dts.de/
# --

package Kernel::System::DTSFreetext;

use strict;
use Kernel::System::Valid;
use Kernel::System::DTSLib;

our $VERSION = "1.0";

sub new ()
{
    my $Type = shift;
    my %Param = @_;
    my $Self = {};

    bless ($Self, $Type);

    # adopt all provided objects
    foreach (keys %Param) {
        $Self->{$_} = $Param{$_};
    }

    # check needed stuff
    foreach (qw(ConfigObject DBObject LogObject)) {
        if (!$Self->{$_}) {
            die "Got no $_!";
        }
    }

    # create needed objects
    $Self->{ValidObject} = Kernel::System::Valid->new(%Param);
    $Self->{DTSLibObject} = Kernel::System::DTSLib->new(%Param);

    return $Self;
}

# get hash with all possible keys and texts (freetextobjects)
sub FreetextObjects ()
{
    my $Self = shift;
    my %Param = @_;
    my %Objects = ();

    for (my $i = 1; $i <= 16; $i++) {
        foreach (qw(Key Text)) {
            my $Name = "TicketFree".$_.$i;
            if (defined $Self->{ConfigObject}->Get($Name)) {
                $Objects{$Name} = $i;
            }
        }
    }

    return %Objects;
}

# get list of freetext
sub FreetextList ()
{
    my $Self = shift;
    my %Param = @_;
    my $DBObject = $Self->{DBObject};

    my $SQL = "SELECT queue_id, object, name, valid_id FROM dts_queue2freetext";
    my @Condition = ();

    if (defined $Param{QueueID}) {
        push @Condition, "queue_id=".
            $DBObject->Quote($Param{QueueID}, "Integer");
    }
    if (defined $Param{Object}) {
        push @Condition, "object='".$DBObject->Quote($Param{Object})."'";
    }
    if (defined $Param{Name}) {
        push @Condition, "name='".$DBObject->Quote($Param{Name})."'";
    }
    if (defined $Param{Valid}) {
        push @Condition, "valid_id IN (".join(",", map {
            $DBObject->Quote($_, "Integer")
        } $Self->{ValidObject}->ValidIDsGet()).")";
    }

    if ($#Condition >= 0) {
        $SQL .= " WHERE ".join(" AND ", @Condition);
    }

    if (!$DBObject->Prepare(SQL => $SQL)) {
        $Self->{LogObject}->Log(
            Priority => "Error",
            Message => $DBObject->Error()
        );
        return;
    }

    my @Data = ();
    while (my @Row = $DBObject->FetchrowArray()) {
        my %Record = (
            QueueID => $Row[0],
            Object => $Row[1],
            Name => $Row[2],
            ValidID => $Row[3]
        );
        push @Data, \%Record;
    }

    return @Data;
}

# insert a new freetext
sub FreetextAdd ()
{
    my $Self = shift;
    my %Param = @_;
    my $DBObject = $Self->{DBObject};

    my $SQL = "INSERT INTO dts_queue2freetext ".
        "(queue_id, object, name, ".
        "valid_id, create_time, create_by, change_time, change_by) VALUES (".
       $DBObject->Quote($Param{QueueID}, "Integer").", '".
       $DBObject->Quote($Param{Object})."', '".
       $DBObject->Quote($Param{Newname})."', ".
       $DBObject->Quote($Param{ValidID}, "Integer").", current_timestamp, ".
       $DBObject->Quote($Self->{UserID}, "Integer").", current_timestamp, ".
       $DBObject->Quote($Self->{UserID}, "Integer").")";
    if (!$DBObject->Do(SQL => $SQL)) {
        $Self->{LogObject}->Log(
            Priority => "Error",
            Message => $DBObject->Error()
        );
        return;
    }

    if (!$Self->UpdateFreetextFile(Object => $Param{Object})) {
        return;
    }

    return 1;
}

# update a freetext
sub FreetextModify ()
{
    my $Self = shift;
    my %Param = @_;
    my $DBObject = $Self->{DBObject};

    my $SQL = "UPDATE dts_queue2freetext SET name='".
       $DBObject->Quote($Param{Newname})."', valid_id=".
       $DBObject->Quote($Param{ValidID}, "Integer").", change_by=".
       $DBObject->Quote($Self->{UserID}, "Integer").", change_time=".
       "current_timestamp WHERE queue_id=".
       $DBObject->Quote($Param{QueueID}, "Integer")." AND object='".
       $DBObject->Quote($Param{Object})."' AND name='".
       $DBObject->Quote($Param{Name})."'";
    if (!$DBObject->Do(SQL => $SQL)) {
        $Self->{LogObject}->Log(
            Priority => "Error",
            Message => $DBObject->Error()
        );
        return;
    }

    if (!$Self->UpdateFreetextFile(Object => $Param{Object})) {
        return;
    }

    return 1;
}

# update freetext file for a given freetext object
sub UpdateFreetextFile ()
{
    my $Self = shift;
    my %Param = @_;

    my $DBObject = $Self->{DBObject};
    my $LogObject = $Self->{LogObject};
    my $Object = $Param{Object};

    my @List = $Self->FreetextList(Object => $Object);
    my $Data = join("", map { "'".$_->{Name}."' => '".$_->{Name}."',\n" } @List);

    if (!$Self->{DTSLibObject}->WriteVersionedFile(
        FileName => $Self->{ConfigObject}->Get("DTSFreetext::".$Object),
        Data => \$Data
    )) {
        return;
    }

    return 1;
}

1;
