--
-- DTSFreetext.pgsql.sql - adds acl based freetexts to a PostgreSQL based OTRS
-- Copyright (C) 2007, DTS Service GmbH, http://www.dts.de/
--

-- create freetext table
CREATE TABLE dts_queue2freetext (
    queue       INTEGER      NOT NULL REFERENCES queue,
    object      VARCHAR(16)  NOT NULL CHECK(char_length(object) > 0),
    name        VARCHAR(100) NOT NULL CHECK(char_length(name) > 0),
    valid_id    INTEGER      NOT NULL REFERENCES valid,
    create_time TIMESTAMP WITHOUT TIME ZONE NOT NULL,
    create_by   INTEGER      NOT NULL REFERENCES system_user,
    change_time TIMESTAMP WITHOUT TIME ZONE NOT NULL,
    change_by   INTEGER      NOT NULL REFERENCES system_user,
    PRIMARY KEY (queue, object, name)
);

CREATE INDEX dts_queue2freetext_object_key ON dts_queue2freetext(object);
