# --
# Kernel/System/DTSAddress.pm - collection of DTSAddress specific functions
# Copyright (C) 2007, DTS Service GmbH, http://www.dts.de/
# --

package Kernel::System::DTSAddress;

use strict;
use warnings;
use Kernel::System::Valid;

our $VERSION = "1.0";

sub new {
    my $Type = shift;
    my %Param = @_;

    my $Self = {};
    bless($Self, $Type);

    # adopt all provided objects
    foreach (keys %Param) {
        $Self->{$_} = $Param{$_};
    }

    # check needed stuff
    foreach (qw(DBObject LogObject)) {
        if (!$Self->{$_}) {
            die "Got no $_!";
        }
    }

    # create needed objects
    $Self->{ValidObject} = Kernel::System::Valid->new(%Param);

    return $Self;
}

# return all addresses as a hash with references to hashes
sub AddressList ()
{
    my $Self = shift;
    my %Param = @_;
    my $DBObject = $Self->{DBObject};

    my $SQL = "SELECT name, address, ".
        "valid_id, create_time, create_by, change_time, change_by ".
        "FROM dts_address";
    my @Clauses = ();
    if ($Param{Valid}) {
        push @Clauses, "valid_id IN (".
            join(",", $Self->{ValidObject}->ValidIDsGet()).")";
    }
    if ($Param{Name}) {
        push @Clauses, "name='".$DBObject->Quote($Param{Name})."'";
    }
    if (@Clauses) {
        $SQL .= " WHERE ".join(" AND ", @Clauses);
    }
    if (!$DBObject->Prepare(SQL => $SQL)) {
        $Self->{LogObject}->Log(
            Priority => "Error",
            Message => $DBObject->Error()
        );
        return;
    }
    my %Data = ();
    while (my @Row = $DBObject->FetchrowArray()) {
        my $Name = $Row[0];
        $Data{$Name}->{Address} = $Row[1];
        $Data{$Name}->{ValidID} = $Row[2];
        $Data{$Name}->{CreateTime} = $Row[3];
        $Data{$Name}->{CreateBy} = $Row[4];
        $Data{$Name}->{ChangeTime} = $Row[5];
        $Data{$Name}->{ChangeBy} = $Row[6];
    }

    return %Data;
}

# create a new address
sub AddressAdd ()
{
    my $Self = shift;
    my %Param = @_;
    my $DBObject = $Self->{DBObject};

    my $SQL = "INSERT INTO dts_address (name, address, ".
        "valid_id, create_time, create_by, change_time, change_by) VALUES ('".
        $DBObject->Quote($Param{Name})."', '".
        $DBObject->Quote($Param{Address})."', ".
        $DBObject->Quote($Param{ValidID}, "Integer").", current_timestamp, ".
        $DBObject->Quote($Self->{UserID}, "Integer").", current_timestamp, ".
        $DBObject->Quote($Self->{UserID}, "Integer").")";
    if (!$DBObject->Do(SQL => $SQL)) {
        $Self->{LogObject}->Log(
            Priority => "Error",
            Message => $DBObject->Error()
        );
        return;
    }

    return 1;
}

# update an address
sub AddressModify ()
{
    my $Self = shift;
    my %Param = @_;
    my $DBObject = $Self->{DBObject};

    my $SQL = "UPDATE dts_address SET name='".
        $DBObject->Quote($Param{Name})."', address='".
        $DBObject->Quote($Param{Address})."', valid_id=".
        $DBObject->Quote($Param{ValidID}, "Integer").", change_by=".
        $DBObject->Quote($Self->{UserID}, "Integer").", change_time=".
        "current_timestamp WHERE name='".
        $DBObject->Quote($Param{OldName})."'";
    if (!$DBObject->Do(SQL => $SQL)) {
        $Self->{LogObject}->Log(
            Priority => "Error",
            Message => $DBObject->Error()
        );
        return;
    }

    return 1;
}

1;
