/*
 * Decompiled with CFR 0.152.
 */
package augtv;

import java.awt.Dialog;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormatSymbols;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

final class IterationDialog
extends JDialog
implements ActionListener {
    private static final String[] weekdays = new DateFormatSymbols(Locale.ENGLISH).getWeekdays();
    private static final String[] radioButtonLabels = new String[]{"none", "daily", "weekly", "weekdays", "weekends"};
    private final JRadioButton[] radioButtons;
    private String iteration;

    IterationDialog() {
        JPanel iterationPanel = new JPanel();
        iterationPanel.setBorder(BorderFactory.createTitledBorder("Select iteration"));
        iterationPanel.setLayout(new GridLayout(radioButtonLabels.length, 1));
        this.radioButtons = new JRadioButton[radioButtonLabels.length];
        ButtonGroup buttonGroup = new ButtonGroup();
        for (int i = 0; i < radioButtonLabels.length; ++i) {
            this.radioButtons[i] = new JRadioButton(radioButtonLabels[i]);
            this.radioButtons[i].setActionCommand(radioButtonLabels[i]);
            iterationPanel.add(this.radioButtons[i]);
            buttonGroup.add(this.radioButtons[i]);
        }
        this.radioButtons[0].setSelected(true);
        JPanel buttonPanel = new JPanel();
        JButton okButton = new JButton("OK");
        okButton.setActionCommand("OK");
        okButton.addActionListener(this);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.setActionCommand("Cancel");
        cancelButton.addActionListener(this);
        buttonPanel.add(okButton);
        buttonPanel.add(cancelButton);
        this.setTitle("Record");
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setResizable(false);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.getContentPane().add(iterationPanel);
        this.getContentPane().add(buttonPanel);
        this.getRootPane().setDefaultButton(okButton);
        this.pack();
    }

    public final void setVisible(boolean visible) {
        if (visible) {
            this.iteration = "";
        }
        super.setVisible(visible);
    }

    public final void actionPerformed(ActionEvent e) {
        if ("OK".equals(e.getActionCommand())) {
            String newIteration = "";
            for (JRadioButton radioButton : this.radioButtons) {
                if (!radioButton.isSelected()) continue;
                newIteration = radioButton.getActionCommand();
                break;
            }
            this.iteration = newIteration;
            this.setVisible(false);
        } else if ("Cancel".equals(e.getActionCommand())) {
            this.setVisible(false);
        }
    }

    public final String getIteration(int programWeekday) {
        return "weekly".equals(this.iteration) ? weekdays[programWeekday] : this.iteration;
    }
}

