/*
 * Decompiled with CFR 0.152.
 */
package augtv;

import devplugin.Channel;
import devplugin.Plugin;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.table.AbstractTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StationMappingTableModel
extends AbstractTableModel {
    private String[][] stationMapping = new String[0][];
    private final Hashtable<String, Integer> remoteStations = new Hashtable();
    private int rowCount = 0;

    public final void setRemoteStations(Map<String, Integer> newRemoteStations) {
        this.remoteStations.clear();
        this.remoteStations.putAll(newRemoteStations);
        this.fireTableDataChanged();
    }

    public final void setStationMapping(Hashtable<String, String> newStationMapping) {
        Channel[] channels = Plugin.getPluginManager().getSubscribedChannels();
        this.rowCount = channels.length;
        this.stationMapping = new String[this.rowCount][];
        for (int i = 0; i < this.rowCount; ++i) {
            String localStationName = channels[i].getName();
            String remoteStationName = newStationMapping.get(localStationName);
            this.stationMapping[i] = new String[]{localStationName, remoteStationName == null ? localStationName : remoteStationName};
        }
        this.fireTableDataChanged();
    }

    public final Hashtable<String, String> getStationMapping() {
        Hashtable<String, String> newStationMapping = new Hashtable<String, String>(this.rowCount);
        for (String[] localAndRemoteStationName : this.stationMapping) {
            newStationMapping.put(localAndRemoteStationName[0], localAndRemoteStationName[1]);
        }
        return newStationMapping;
    }

    public final boolean isValidMapping(int rowIndex) {
        return this.remoteStations.containsKey(this.stationMapping[rowIndex][1]);
    }

    @Override
    public final Object getValueAt(int rowIndex, int columnIndex) {
        return this.stationMapping[rowIndex][columnIndex];
    }

    @Override
    public final int getColumnCount() {
        return 2;
    }

    @Override
    public final int getRowCount() {
        return this.rowCount;
    }

    @Override
    public final String getColumnName(int columnIndex) {
        return columnIndex == 0 ? "TV-Browser" : "EyeTV";
    }

    @Override
    public final boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex > 0;
    }

    @Override
    public final void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.stationMapping[rowIndex][1] = aValue.toString();
    }
}

