/*
 * Decompiled with CFR 0.152.
 */
package augtv;

import augtv.IterationDialog;
import augtv.StationMappingTableModel;
import devplugin.ActionMenu;
import devplugin.Date;
import devplugin.Plugin;
import devplugin.PluginInfo;
import devplugin.Program;
import devplugin.ProgramFieldType;
import devplugin.SettingsTab;
import devplugin.Version;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableCellRenderer;
import util.exc.TvBrowserException;

public final class AugTV
extends Plugin
implements SettingsTab {
    private static final Version VERSION = new Version(0, 0, 2, true);
    private static final PluginInfo INFO = new PluginInfo(AugTV.class, "AugTV", "Exports program schedules from TV-Browser to EyeTV", "Felix J. Ogris (fjo@ogris.de)", "GPL", "http://ogris.de/augtv");
    private static final String[] DATETIMENAME = new String[]{"year", "month", "day", "hour", "minute", "second"};
    private static final Color ERRORCOLOR = new Color(255, 63, 63);
    private final Hashtable<Program, String[]> scheduledPrograms = new Hashtable();
    private final ImageIcon smiley;
    private final JTextField cgiUrlField = new JTextField();
    private final JTextField timeOffsetField = new JTextField();
    private String cgiUrl;
    private int timeOffset;
    private final JPanel settingsPanel = new JPanel();
    private final StationMappingTableModel stationMappingModel = new StationMappingTableModel();
    private final JTable stationMappingTable = new JTable(this.stationMappingModel);
    private final Hashtable<String, String> stationMapping = new Hashtable();
    private final TreeMap<String, Integer> remoteStations = new TreeMap();
    private final JComboBox remoteStationsComboBox = new JComboBox();
    private final IterationDialog iterationDialog = new IterationDialog();
    private boolean configured = false;

    public AugTV() {
        this.smiley = this.createImageIcon("smiley.png");
        JButton checkButton = new JButton("Check");
        checkButton.addActionListener(new AbstractAction(){

            public final void actionPerformed(ActionEvent e) {
                AugTV.this.checkSettings(true);
                if (AugTV.this.configured && AugTV.this.loadPrograms() && AugTV.this.loadRemoteStations() && AugTV.this.loadDatetime()) {
                    JOptionPane.showMessageDialog(null, "Connection succeeded", "AugTV", 1, AugTV.this.smiley);
                }
            }
        });
        JPanel serverPanel = new JPanel();
        serverPanel.setBorder(BorderFactory.createTitledBorder("Server settings"));
        JLabel urlLabel = new JLabel("Url:");
        JLabel timeLabel = new JLabel("Time offset:");
        this.timeOffsetField.setToolTipText("Time in minutes that the server is behind");
        GroupLayout serverLayout = new GroupLayout(serverPanel);
        serverLayout.setHorizontalGroup(serverLayout.createSequentialGroup().addGroup(serverLayout.createSequentialGroup().addComponent(urlLabel).addComponent(this.cgiUrlField, -2, 200, Integer.MAX_VALUE).addContainerGap()).addGroup(serverLayout.createSequentialGroup().addComponent(timeLabel).addComponent(this.timeOffsetField, -2, 50, 50).addContainerGap()).addComponent(checkButton));
        serverLayout.setVerticalGroup(serverLayout.createSequentialGroup().addGroup(serverLayout.createBaselineGroup(false, false).addComponent(urlLabel).addComponent(this.cgiUrlField).addComponent(timeLabel).addComponent(this.timeOffsetField).addComponent(checkButton)));
        serverPanel.setLayout(serverLayout);
        this.remoteStationsComboBox.setEditable(true);
        this.stationMappingTable.getColumnModel().getColumn(1).setCellEditor(new DefaultCellEditor(this.remoteStationsComboBox));
        this.stationMappingTable.getColumnModel().getColumn(1).setCellRenderer(new DefaultTableCellRenderer(){

            public final Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component cell = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (isSelected) {
                    cell.setBackground(table.getSelectionBackground());
                } else if (AugTV.this.stationMappingModel.isValidMapping(row)) {
                    cell.setBackground(table.getBackground());
                } else {
                    cell.setBackground(ERRORCOLOR);
                }
                return cell;
            }
        });
        JPanel mappingPanel = new JPanel();
        mappingPanel.setLayout(new BoxLayout(mappingPanel, 3));
        mappingPanel.setBorder(BorderFactory.createTitledBorder("Station mappings"));
        mappingPanel.add(new JScrollPane(this.stationMappingTable));
        this.settingsPanel.setLayout(new BoxLayout(this.settingsPanel, 3));
        this.settingsPanel.add(serverPanel);
        this.settingsPanel.add(mappingPanel);
    }

    private void showError(String errMsg) {
        JOptionPane.showMessageDialog(null, errMsg, "AugTV", 0);
    }

    private Integer tryInteger(String src, String errMsg) {
        try {
            return Integer.parseInt(src);
        }
        catch (Exception e) {
            this.showError("Server returned invalid " + errMsg + ": " + src);
            return null;
        }
    }

    private boolean loadPrograms() {
        String[] lines;
        try {
            lines = this.getUrl("programs", null);
        }
        catch (IOException e) {
            this.showError("Cannot get programs: " + e);
            return false;
        }
        Hashtable<Program, String[]> newScheduledPrograms = new Hashtable<Program, String[]>(this.scheduledPrograms.size());
        Integer[] dates = new Integer[DATETIMENAME.length];
        for (int lineNum = 1; lineNum < lines.length; ++lineNum) {
            Program[] programs;
            String[] fields = lines[lineNum].split("\t");
            boolean enabled = Boolean.parseBoolean(fields[15]);
            if (!enabled) continue;
            for (int numDate = DATETIMENAME.length - 1; numDate >= 0; --numDate) {
                dates[numDate] = this.tryInteger(fields[numDate + 1], DATETIMENAME[numDate]);
                if (dates[numDate] != null) continue;
                return false;
            }
            Integer duration = this.tryInteger(fields[7], "duration");
            if (duration == null) {
                return false;
            }
            String station = this.getLocalStationName(fields[11]);
            String repeats = fields[13];
            String id = fields[16];
            try {
                programs = AugTV.getPluginManager().createProgramSearcher(3, ".*", true).search(new ProgramFieldType[]{ProgramFieldType.TITLE_TYPE}, new Date(dates[0].intValue(), dates[1].intValue(), dates[2].intValue()), 1, null, false);
            }
            catch (TvBrowserException e) {
                this.showError("Cannot search for programs: " + (Object)((Object)e));
                return false;
            }
            for (Program program : programs) {
                Date date = program.getDate();
                if (date.getYear() != dates[0].intValue() || date.getMonth() != dates[1].intValue() || date.getDayOfMonth() != dates[2].intValue() || program.getHours() != dates[3].intValue() || program.getMinutes() != dates[4].intValue() || program.getLength() * 60 != duration || !program.getChannel().getName().equals(station)) continue;
                program.mark((Plugin)this);
                newScheduledPrograms.put(program, new String[]{id, repeats});
            }
        }
        for (Program program : this.scheduledPrograms.keySet()) {
            if (newScheduledPrograms.containsKey(program)) continue;
            program.unmark((Plugin)this);
        }
        this.scheduledPrograms.clear();
        this.scheduledPrograms.putAll(newScheduledPrograms);
        return true;
    }

    private void recordProgram(Program program) {
        Date date = program.getDate();
        String description = program.getDescription();
        this.iterationDialog.setLocationRelativeTo(this.getParentFrame());
        this.iterationDialog.setVisible(true);
        String iteration = this.iterationDialog.getIteration(program.getDate().getDayOfWeek());
        if (iteration.isEmpty()) {
            return;
        }
        try {
            this.getUrl("record", "station=" + this.encode(this.getRemoteStationName(program.getChannel().getName())) + "&title=" + this.encode(program.getTitle()) + "&description=" + (description == null ? "" : this.encode(description)) + "&duration=" + program.getLength() * 60 + "&year=" + date.getYear() + "&month=" + date.getMonth() + "&day=" + date.getDayOfMonth() + "&hour=" + program.getHours() + "&minute=" + program.getMinutes() + "&repeats=" + iteration);
        }
        catch (Exception e) {
            this.showError("Cannot record program: " + e);
        }
        this.loadPrograms();
    }

    private void cancelProgram(Program program) {
        String[] idAndRepeats = this.scheduledPrograms.get(program);
        if (idAndRepeats == null || "none".equals(idAndRepeats[1]) || JOptionPane.showConfirmDialog(null, "Delete series?", "AugTV", 0) == 0) {
            try {
                this.getUrl("delete", "id=" + idAndRepeats[0]);
            }
            catch (Exception e) {
                this.showError("Cannot cancel recording: " + e);
            }
            this.loadPrograms();
        }
    }

    private String encode(String str) throws UnsupportedEncodingException {
        return URLEncoder.encode(str, "ISO-8859-1");
    }

    private boolean loadRemoteStations() {
        String[] lines;
        try {
            lines = this.getUrl("channels", null);
        }
        catch (Exception e) {
            this.showError("Cannot get channels: " + e);
            return false;
        }
        this.remoteStations.clear();
        for (String line : lines) {
            String[] nameAndNumber = line.split("\t");
            if (nameAndNumber.length != 2) continue;
            Integer channel = this.tryInteger(nameAndNumber[1], "channel number");
            if (channel == null) {
                return false;
            }
            this.remoteStations.put(nameAndNumber[0], channel);
        }
        this.stationMappingModel.setRemoteStations(this.remoteStations);
        this.remoteStationsComboBox.removeAllItems();
        for (String name : this.remoteStations.keySet()) {
            this.remoteStationsComboBox.addItem(name);
        }
        return true;
    }

    private boolean loadDatetime() {
        String[] lines;
        try {
            lines = this.getUrl("datetime", null);
        }
        catch (Exception e) {
            this.showError("Cannot get date and time: " + e);
            return false;
        }
        Calendar calendar = Calendar.getInstance();
        int[] datetime = new int[DATETIMENAME.length];
        for (String line : lines) {
            String[] datetimeStr = line.split("\t");
            if (datetimeStr.length != DATETIMENAME.length) continue;
            for (int i = DATETIMENAME.length - 1; i >= 0; --i) {
                Integer field = this.tryInteger(datetimeStr[i], DATETIMENAME[i]);
                if (field == null) {
                    return false;
                }
                datetime[i] = field;
            }
        }
        calendar.set(datetime[0], datetime[1] - 1, datetime[2], datetime[3], datetime[4], datetime[5]);
        long offset = Calendar.getInstance().getTimeInMillis() - calendar.getTimeInMillis();
        this.timeOffsetField.setText(Long.toString(offset / 60000L));
        return true;
    }

    private String[] getUrl(String action, String query) throws IOException {
        byte[] buffer;
        int readlen;
        StringBuilder raw = new StringBuilder();
        InputStream is = new URL(this.cgiUrl + "?output=text&action=" + action + (query == null ? "" : "&" + query)).openStream();
        while ((readlen = is.read(buffer = new byte[is.available()])) >= 0) {
            raw.append(new String(buffer, 0, readlen));
        }
        is.close();
        String[] lines = raw.toString().split("\n");
        if (lines.length <= 0) {
            throw new IOException("no reply from server");
        }
        if (!"OK".equals(lines[0])) {
            throw new IOException(lines.length > 1 ? lines[1] : "error from server without further details");
        }
        return lines;
    }

    private void checkSettings(boolean showDialog) {
        block5: {
            this.configured = false;
            this.cgiUrl = this.cgiUrlField.getText();
            try {
                new URL(this.cgiUrl).toURI();
            }
            catch (Exception e) {
                if (showDialog) {
                    this.showError("Invalid CGI url: " + this.cgiUrl);
                }
                return;
            }
            try {
                this.timeOffset = Integer.parseInt(this.timeOffsetField.getText());
            }
            catch (Exception e) {
                if (!showDialog) break block5;
                this.showError("Invalid time offset: " + this.timeOffsetField.getText());
                return;
            }
        }
        this.configured = true;
    }

    private String getLocalStationName(String remoteStationName) {
        for (Map.Entry<String, String> entry : this.stationMapping.entrySet()) {
            if (!remoteStationName.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return remoteStationName;
    }

    private String getRemoteStationName(String localStationName) {
        String remoteStationName = this.stationMapping.get(localStationName);
        return remoteStationName == null ? localStationName : remoteStationName;
    }

    private boolean isScheduled(Program program) {
        return this.scheduledPrograms.containsKey(program);
    }

    public final JPanel createSettingsPanel() {
        this.cgiUrlField.setText(this.cgiUrl);
        this.stationMappingModel.setStationMapping(this.stationMapping);
        return this.settingsPanel;
    }

    public final Icon getIcon() {
        return null;
    }

    public final String getTitle() {
        return null;
    }

    public final void saveSettings() {
        this.checkSettings(true);
        this.stationMapping.putAll(this.stationMappingModel.getStationMapping());
    }

    public final Properties storeSettings() {
        Properties settings = new Properties();
        settings.setProperty("cgiPath", this.cgiUrl);
        settings.setProperty("timeOffset", Integer.toString(this.timeOffset));
        for (Map.Entry<String, String> entry : this.stationMapping.entrySet()) {
            if (entry.getKey().equals(entry.getValue())) continue;
            settings.setProperty("_" + entry.getKey(), entry.getValue());
        }
        return settings;
    }

    public final void loadSettings(Properties settings) {
        this.cgiUrl = settings.getProperty("cgiPath", "http://<IP_of_EyeTV_Host>/cgi-bin/augtv.pl");
        try {
            this.timeOffset = Integer.parseInt(settings.getProperty("timeOffset", "0"));
        }
        catch (Exception e) {
            this.timeOffset = 0;
        }
        for (Map.Entry<Object, Object> entry : settings.entrySet()) {
            String key = entry.getKey().toString();
            if (!key.startsWith("_")) continue;
            this.stationMapping.put(key.substring(1), entry.getValue().toString());
        }
        this.cgiUrlField.setText(this.cgiUrl);
        this.timeOffsetField.setText(Integer.toString(this.timeOffset));
        this.stationMappingModel.setStationMapping(this.stationMapping);
        this.checkSettings(false);
        if (this.configured) {
            this.loadPrograms();
            this.loadRemoteStations();
        }
    }

    public final SettingsTab getSettingsTab() {
        return this;
    }

    protected final String getMarkIconName() {
        return "augtv.png";
    }

    public int getMarkPriorityForProgram(Program p) {
        return 2;
    }

    public static Version getVersion() {
        return VERSION;
    }

    public final PluginInfo getInfo() {
        return INFO;
    }

    public final ActionMenu getContextMenuActions(final Program program) {
        String cmdConfigure = "AugTV: Configure...";
        String cmdCancel = "AugTV: Cancel recording";
        String cmdRecord = "AugTV: Record";
        final AugTV plugin = this;
        AbstractAction action = new AbstractAction(){

            public final void actionPerformed(ActionEvent e) {
                String cmd = e.getActionCommand();
                if (cmd.equals("AugTV: Configure...")) {
                    Plugin.getPluginManager().showSettings(plugin);
                } else if (cmd.equals("AugTV: Cancel recording")) {
                    AugTV.this.cancelProgram(program);
                } else if (cmd.equals("AugTV: Record")) {
                    AugTV.this.recordProgram(program);
                }
            }
        };
        String localStationName = program.getChannel().getName();
        String remoteStationName = this.stationMapping.get(localStationName);
        action.putValue("SmallIcon", this.createImageIcon(this.getMarkIconName()));
        if (!this.configured || !this.remoteStations.containsKey(remoteStationName == null ? localStationName : remoteStationName)) {
            action.putValue("Name", "AugTV: Configure...");
        } else if (this.isScheduled(program)) {
            action.putValue("Name", "AugTV: Cancel recording");
        } else {
            action.putValue("Name", "AugTV: Record");
        }
        return new ActionMenu((Action)action);
    }
}

