/*
 * Decompiled with CFR 0.152.
 */
package net.ogris.ampcontrol;

import java.awt.event.ActionEvent;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

final class Main
extends JFrame
implements Runnable,
ChangeListener {
    private static final String NEWLINE = System.getProperty("line.separator");
    private final List<String> events = Collections.synchronizedList(new ArrayList());
    private final JTextField hostField = new JTextField("onkyo");
    private final JTextField portField = new JTextField("60128");
    private final JButton connectButton = new JButton();
    private final JButton powerButton = new JButton();
    private final JSlider loudnessSlider = new JSlider();
    private final JButton muteButton = new JButton();
    private Thread thread = null;
    private Socket socket;
    private String host;
    private int port;
    private boolean connected;
    private boolean powered;
    private int loudness;
    private boolean muted;

    Main() {
        this.setConnected(false);
        this.setPowered(false);
        this.setMuted(false);
        final Main parent = this;
        this.connectButton.addActionListener(new AbstractAction(){

            public final void actionPerformed(ActionEvent e) {
                if (Main.this.connected) {
                    Main.this.connected = false;
                } else if (Main.this.thread == null || !Main.this.thread.isAlive()) {
                    Main.this.host = Main.this.hostField.getText();
                    try {
                        Main.this.port = Integer.parseInt(Main.this.portField.getText());
                    }
                    catch (Exception ex) {
                        JOptionPane.showMessageDialog(parent, "Invalid port: " + Main.this.portField.getText(), "Invalid port", 0);
                        return;
                    }
                    Main.this.thread = new Thread(parent);
                    Main.this.thread.start();
                }
            }
        });
        this.powerButton.addActionListener(new AbstractAction(){

            public final void actionPerformed(ActionEvent e) {
                Main.this.events.add("PWR0" + (Main.this.powered ? "0" : "1"));
            }
        });
        this.loudnessSlider.addChangeListener(parent);
        this.muteButton.addActionListener(new AbstractAction(){

            public final void actionPerformed(ActionEvent e) {
                Main.this.events.add("AMT0" + (Main.this.muted ? "0" : "1"));
            }
        });
        JPanel ampPanel = new JPanel();
        ampPanel.setBorder(BorderFactory.createTitledBorder("Amp address"));
        JLabel colon = new JLabel(":");
        GroupLayout ampLayout = new GroupLayout(ampPanel);
        ampLayout.setHorizontalGroup(ampLayout.createSequentialGroup().addComponent(this.hostField, -2, 100, Integer.MAX_VALUE).addComponent(colon).addComponent(this.portField, 50, 50, 50).addContainerGap().addComponent(this.connectButton));
        ampLayout.setVerticalGroup(ampLayout.createBaselineGroup(false, false).addComponent(this.hostField).addComponent(colon).addComponent(this.portField).addComponent(this.connectButton));
        ampPanel.setLayout(ampLayout);
        JPanel loudnessPanel = new JPanel();
        loudnessPanel.setBorder(BorderFactory.createTitledBorder("Loudness"));
        GroupLayout loudnessLayout = new GroupLayout(loudnessPanel);
        loudnessLayout.setHorizontalGroup(loudnessLayout.createSequentialGroup().addComponent(this.loudnessSlider));
        loudnessLayout.setVerticalGroup(loudnessLayout.createBaselineGroup(false, false).addComponent(this.loudnessSlider));
        loudnessPanel.setLayout(loudnessLayout);
        JPanel mainPanel = new JPanel();
        GroupLayout mainLayout = new GroupLayout(mainPanel);
        mainLayout.setHorizontalGroup(mainLayout.createSequentialGroup().addComponent(this.powerButton).addComponent(loudnessPanel).addComponent(this.muteButton));
        mainLayout.setVerticalGroup(mainLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.powerButton).addComponent(loudnessPanel).addComponent(this.muteButton));
        mainPanel.setLayout(mainLayout);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 3));
        this.getContentPane().add(ampPanel);
        this.getContentPane().add(mainPanel);
        this.setDefaultCloseOperation(3);
        this.setTitle("Amp Control");
        this.pack();
    }

    public final void stateChanged(ChangeEvent e) {
        if (!this.loudnessSlider.getValueIsAdjusting() && this.loudness != this.loudnessSlider.getValue()) {
            this.events.add("MVL" + String.format("%02X", this.loudnessSlider.getValue()));
        }
    }

    private void setConnected(final boolean connected) {
        this.connected = connected;
        SwingUtilities.invokeLater(new Runnable(){

            public final void run() {
                Main.this.connectButton.setText(connected ? "Disconnect" : "Connect");
                Main.this.hostField.setEnabled(!connected);
                Main.this.portField.setEnabled(!connected);
                Main.this.powerButton.setEnabled(connected);
                Main.this.loudnessSlider.setEnabled(connected);
                Main.this.muteButton.setEnabled(connected);
            }
        });
    }

    private void setPowered(final boolean powered) {
        this.powered = powered;
        SwingUtilities.invokeLater(new Runnable(){

            public final void run() {
                Main.this.powerButton.setText(powered ? "Power off" : "Power on");
            }
        });
    }

    private void setLoudness(final int loudness) {
        this.loudness = loudness;
        SwingUtilities.invokeLater(new Runnable(){

            public final void run() {
                Main.this.loudnessSlider.setValue(loudness);
            }
        });
    }

    private void setMuted(final boolean muted) {
        this.muted = muted;
        SwingUtilities.invokeLater(new Runnable(){

            public final void run() {
                Main.this.muteButton.setText(muted ? "Demute" : "Mute");
            }
        });
    }

    public final void run() {
        try {
            this.socket = new Socket(this.host, this.port);
        }
        catch (Exception e) {
            this.showError("Cannot connect", "Cannot connect to " + this.host + ":" + this.port + ":" + NEWLINE + NEWLINE + e);
            return;
        }
        this.setConnected(true);
        this.send("PWRQSTN");
        this.send("MVLQSTN");
        this.send("AMTQSTN");
        while (this.connected) {
            if (!this.events.isEmpty()) {
                this.send(this.events.remove(0));
            }
            try {
                Thread.sleep(500L);
            }
            catch (Exception e) {
                // empty catch block
            }
            this.receive();
        }
        try {
            this.socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setConnected(false);
    }

    private void send(String command) {
        byte[] cmd = command.getBytes();
        int len = 2 + cmd.length + 1;
        byte[] data = new byte[16 + len];
        data[0] = 73;
        data[1] = 83;
        data[2] = 67;
        data[3] = 80;
        data[4] = 0;
        data[5] = 0;
        data[6] = 0;
        data[7] = 16;
        data[11] = (byte)(len % 256);
        data[10] = (byte)((len /= 256) % 256);
        data[9] = (byte)((len /= 256) % 256);
        data[8] = (byte)((len /= 256) % 256);
        len /= 256;
        data[12] = 1;
        data[13] = 0;
        data[14] = 0;
        data[15] = 0;
        data[16] = 33;
        data[17] = 49;
        System.arraycopy(cmd, 0, data, 18, cmd.length);
        data[data.length - 1] = 13;
        try {
            this.socket.getOutputStream().write(data);
        }
        catch (Exception e) {
            this.showError("Cannot send", "Cannot send command '" + command + "':" + NEWLINE + NEWLINE + e);
            return;
        }
        try {
            Thread.sleep(100L);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private void receive() {
        int len;
        byte[] data;
        int datalen;
        try {
            if (datalen <= 0) {
                return;
            }
            data = new byte[datalen];
            this.socket.getInputStream().read(data);
        }
        catch (Exception e) {
            this.showError("Cannot receive", "Cannot receive data:" + NEWLINE + NEWLINE + e);
            return;
        }
        for (datalen = this.socket.getInputStream().available(); datalen > 0; datalen -= len + 16) {
            if (datalen <= 20) {
                System.err.println("only " + datalen + " bytes from receiver - need >20");
                return;
            }
            if (data[0] != 73 || data[1] != 83 || data[2] != 67 || data[3] != 80 || data[4] != 0 || data[5] != 0 || data[6] != 0 || data[7] != 16 || data[12] != 1 || data[13] != 0 || data[14] != 0 || data[15] != 0 || data[16] != 33 || data[17] != 49 || data[datalen - 2] != 26 || data[datalen - 1] != 13) {
                System.err.println("bogus packet from receiver");
                return;
            }
            len = data[8] * 256 * 256 * 256 + data[9] * 256 * 256 + data[10] * 256 + data[11];
            if (len + 16 > datalen) {
                System.err.println("receiver claims command length is " + len + " bytes - must be " + (datalen - 16) + " as packet is " + datalen + " bytes");
                return;
            }
            String cmd = new String(data, 18, len - 4);
            if ("PWR00".equals(cmd)) {
                this.setPowered(false);
            } else if ("PWR01".equals(cmd)) {
                this.setPowered(true);
            } else if (cmd.startsWith("MVL")) {
                String volume = cmd.substring(3);
                try {
                    int newloudness = Integer.parseInt(volume, 16);
                    if (newloudness < 0 || newloudness > 100) {
                        System.err.println("receiver send invalid master volume " + volume);
                    }
                    this.setLoudness(newloudness);
                }
                catch (Exception e) {
                    System.err.println("receiver send invalid master volume " + volume + "(" + e + ")");
                }
            } else if ("AMT00".equals(cmd)) {
                this.setMuted(false);
            } else if ("AMT01".equals(cmd)) {
                this.setMuted(true);
            } else {
                System.err.println("unhandled data from receiver: " + cmd);
            }
            System.arraycopy(data, len + 16, data, 0, datalen - len - 16);
        }
    }

    private void showError(final String title, final String message) {
        this.connected = false;
        final Main parent = this;
        SwingUtilities.invokeLater(new Runnable(){

            public final void run() {
                JOptionPane.showMessageDialog(parent, message, title, 0);
            }
        });
    }

    public static void main(String[] args) {
        new Main().setVisible(true);
    }
}

